/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.validator.constraint.enums;

import com.github.damianwajser.validator.annotation.enums.MatchEnum;
import com.github.damianwajser.validator.constraint.AbstractConstraint;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.http.HttpMethod;

public class MatchEnumConstraint
extends AbstractConstraint
implements ConstraintValidator<MatchEnum, Object> {
    private List<String> acceptedValues;

    public void initialize(MatchEnum field) {
        this.initialize(field.excludes(), field.onlyIn(), field.isNulleable(), field.enumClass());
    }

    public MatchEnumConstraint initialize(HttpMethod[] excludes, HttpMethod[] onlyIn, boolean isNulleable, Class<? extends Enum<?>> enumClass) {
        super.initialize(excludes, onlyIn, isNulleable);
        this.acceptedValues = Stream.of(enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.toList());
        return this;
    }

    @Override
    protected boolean hasError(Object field, ConstraintValidatorContext cxt) {
        return !this.acceptedValues.contains(field.toString());
    }
}

