/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.validator.constraint.global;

import com.github.damianwajser.validator.annotation.global.Past;
import com.github.damianwajser.validator.constraint.AbstractConstraint;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class PastConstraint
extends AbstractConstraint
implements ConstraintValidator<Past, Object> {
    public void initialize(Past field) {
        super.initialize(field.excludes(), field.onlyIn(), field.isNulleable());
    }

    @Override
    protected boolean hasError(Object field, ConstraintValidatorContext cxt) {
        boolean result = true;
        if (field != null) {
            if (LocalDate.class.isAssignableFrom(field.getClass())) {
                result = LocalDate.now().isBefore((LocalDate)field);
            } else if (LocalDateTime.class.isAssignableFrom(field.getClass())) {
                result = LocalDateTime.now().isBefore((LocalDateTime)field);
            } else if (Date.class.isAssignableFrom(field.getClass())) {
                result = LocalDateTime.now().isBefore(LocalDateTime.ofInstant(((Date)field).toInstant(), ZoneId.systemDefault()));
            }
        }
        return result;
    }
}

