/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.builders.json;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.github.damianwajser.builders.OptionsBuilder;
import com.github.damianwajser.model.Endpoint;
import com.github.damianwajser.model.OptionsResult;
import com.github.damianwajser.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class JsonBuilder
implements OptionsBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonBuilder.class);
    private Object controller;
    private String url;
    @JsonUnwrapped
    private Collection<Method> methods;

    public JsonBuilder(Object obj) {
        LOGGER.info("create options to: " + obj.getClass().getSimpleName());
        this.controller = obj;
    }

    private void fillMethods() {
        this.methods = Arrays.asList(this.controller.getClass().getMethods()).stream().filter(m -> ReflectionUtils.containsRequestAnnotation(m)).collect(Collectors.toList());
    }

    private void fillBaseUrl() {
        String[] urls = this.getUrls(this.controller).orElse(new String[]{"/"});
        this.url = urls.length > 0 ? urls[0] : "/";
    }

    private Optional<String[]> getUrls(Object controller) {
        return Optional.ofNullable((String[])AnnotationUtils.getValue((Annotation)controller.getClass().getAnnotation(RequestMapping.class)));
    }

    @Override
    public Optional<OptionsResult> build() {
        this.getRealController();
        this.fillMethods();
        this.fillBaseUrl();
        Optional<OptionsResult> result = this.getResult();
        result.ifPresent(o -> this.fixEndpoints((OptionsResult)o));
        return result;
    }

    private void fixEndpoints(OptionsResult result) {
        if (result.getBaseUrl().equals("/") && !result.getEnpoints().isEmpty()) {
            HashMap count = new HashMap();
            result.getEnpoints().forEach(e -> {
                LOGGER.info("fixeando relative url: " + e.getRelativeUrl());
                String[] relatives = e.getRelativeUrl().split("/");
                int i = 0;
                while (i < relatives.length) {
                    if (!StringUtils.isEmpty((Object)relatives[i])) {
                        Integer num = count.get(relatives[i]) == null ? 1 : (Integer)count.get(relatives[i]) + 1;
                        count.put(relatives[i], num);
                    }
                    ++i;
                }
            });
            LOGGER.info("Contador de arbol: " + count);
            if (!count.isEmpty()) {
                String realBaseUrl = "/" + (String)Collections.max(count.entrySet(), (entry1, entry2) -> (Integer)entry1.getValue() - (Integer)entry2.getValue()).getKey();
                LOGGER.info("real url for: " + realBaseUrl);
                result.setBaseUrl(realBaseUrl);
                result.getEnpoints().forEach(e -> e.setBaseUrl(realBaseUrl));
            }
        }
    }

    private Optional<OptionsResult> getResult() {
        Optional<OptionsResult> response = Optional.empty();
        String packageName = this.controller.getClass().getPackage().getName();
        if (!packageName.startsWith("org.springframework.boot.autoconfigure.web")) {
            OptionsResult result = new OptionsResult(this.url);
            this.methods.forEach(m -> {
                String relativeUrl = this.getRelativeUrl((Method)m);
                Endpoint endpoint = new Endpoint(this.url, relativeUrl, (Method)m, this.controller);
                if (!endpoint.getHttpMethod().equals(HttpMethod.OPTIONS.toString())) {
                    result.addEnpoint(endpoint);
                }
            });
            response = Optional.of(result);
        }
        return response;
    }

    private String getRelativeUrl(Method m) {
        StringBuilder relativeUrl = new StringBuilder();
        Annotation annotation = ReflectionUtils.filterRequestMappingAnnontations(m).findFirst().get();
        Optional<Object> value = Optional.ofNullable(AnnotationUtils.getValue((Annotation)annotation));
        value.ifPresent(v -> {
            StringBuilder stringBuilder2 = relativeUrl.append(Arrays.asList((String[])v).stream().findFirst().orElse(""));
        });
        return relativeUrl.toString();
    }

    private void getRealController() {
        if (AopUtils.isAopProxy((Object)this.controller)) {
            try {
                LOGGER.debug(this.controller + " spring proxy, get real object");
                this.controller = ((Advised)this.controller).getTargetSource().getTarget();
                LOGGER.debug("Real Object: " + this.controller);
            }
            catch (Exception e) {
                LOGGER.error("Problemas al obtener el controller: " + this.controller, (Throwable)e);
            }
        }
    }
}

