/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.builders.raml;

import com.github.damianwajser.builders.OptionsBuilder;
import com.github.damianwajser.model.Endpoint;
import com.github.damianwajser.model.OptionsResult;
import com.github.damianwajser.model.Parameters;
import com.github.damianwajser.model.QueryString;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamlBuilder
implements OptionsBuilder {
    private static Logger LOGGER = LoggerFactory.getLogger(RamlBuilder.class);
    private OptionsResult controller;

    public RamlBuilder(OptionsResult controller) {
        this.controller = controller;
    }

    @Override
    public Map<String, Object> build() {
        return this.getEnpointsRaml(this.controller);
    }

    private Map<String, Object> getEnpointsRaml(OptionsResult controller) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        HashMap endpoints = new HashMap();
        controller.getEnpoints().forEach(e -> {
            String relativeUrl;
            LOGGER.info("create raml for: " + e);
            String string = relativeUrl = e.getRelativeUrl().isEmpty() ? "/" : e.getRelativeUrl();
            if (!endpoints.containsKey(relativeUrl)) {
                endpoints.put(relativeUrl, this.getMethods((Endpoint)e));
            } else {
                ((Map)endpoints.get(relativeUrl)).putAll(this.getMethods((Endpoint)e));
            }
        });
        root.put(controller.getBaseUrl(), endpoints);
        return root;
    }

    private Map<String, Object> getMethods(Endpoint e) {
        HashMap<String, Object> methods = new HashMap<String, Object>();
        methods.put(e.getHttpMethod(), this.getMethodInfo(e));
        return methods;
    }

    private Object getMethodInfo(Endpoint e) {
        HashMap<String, Map<String, Object>> info = new HashMap<String, Map<String, Object>>();
        Optional<Map<String, Object>> queryParameters = this.getQueryParameters(e.getQueryString());
        if (queryParameters.isPresent()) {
            info.put("queryParameters", queryParameters.get());
        }
        return info;
    }

    private Optional<Map<String, Object>> getQueryParameters(QueryString queryString) {
        HashMap parameters = new HashMap();
        queryString.getParams().forEach(p -> parameters.put(p.getName(), this.getParameterInfo((Parameters)p)));
        return parameters.isEmpty() ? Optional.empty() : Optional.of(parameters);
    }

    private Object getParameterInfo(Parameters p) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("required", p.isRequired());
        info.put("type", p.getType());
        return info;
    }
}

