/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.damianwajser.model.PathVariable;
import com.github.damianwajser.model.QueryString;
import com.github.damianwajser.model.RequestHttpMethod;
import com.github.damianwajser.model.body.Body;
import com.github.damianwajser.model.body.BodyRequest;
import com.github.damianwajser.model.body.BodyResponse;
import java.lang.reflect.Method;
import org.springframework.http.HttpMethod;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonPropertyOrder(value={"endpoint", "httpMethod", "baseUrl", "relativeUrl"})
public class Endpoint
implements Comparable<Endpoint> {
    private QueryString queryString;
    private PathVariable pathVariable;
    @JsonIgnore
    private RequestHttpMethod methods;
    @JsonIgnore
    private String baseUrl;
    private String relativeUrl;
    private Body bodyRequest;
    private Body bodyResponse;

    public Endpoint(String url, String relativeUrl, Method m, Object controller) {
        this.setBaseUrl(url);
        this.setRelativeUrl(relativeUrl);
        this.setPathVariable(new PathVariable(m, this.getRelativeUrl()));
        this.methods = new RequestHttpMethod(m);
        this.queryString = new QueryString(m);
        this.setBodyRequest(new BodyRequest(m, controller.getClass()));
        this.setBodyResponse(new BodyResponse(m, controller.getClass()));
    }

    public String getHttpMethod() {
        return this.methods.getHttpMethod().length == 0 ? "" : this.methods.getHttpMethod()[0].name();
    }

    public QueryString getQueryString() {
        return this.queryString;
    }

    public void setQueryString(QueryString queryString) {
        this.queryString = queryString;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getRelativeUrl() {
        return this.relativeUrl;
    }

    public void setRelativeUrl(String relativeUrl) {
        this.relativeUrl = relativeUrl;
    }

    @JsonGetter(value="endpoint")
    public String toString() {
        return this.getHttpMethod() + " - " + this.getBaseUrl() + this.getRelativeUrl() + (this.queryString.toString().isEmpty() ? "" : "?" + this.queryString);
    }

    @Override
    public int compareTo(Endpoint o) {
        boolean isGet = this.getHttpMethod().equals(HttpMethod.GET.toString());
        return isGet ? 1 : this.getHttpMethod().compareTo(o.getHttpMethod());
    }

    public Body getBodyRequest() {
        return this.bodyRequest;
    }

    public void setBodyRequest(Body bodyRequest) {
        this.bodyRequest = bodyRequest;
    }

    public Body getBodyResponse() {
        return this.bodyResponse;
    }

    public void setBodyResponse(Body bodyResponse) {
        this.bodyResponse = bodyResponse;
    }

    public PathVariable getPathVariable() {
        return this.pathVariable;
    }

    public void setPathVariable(PathVariable pathVariable) {
        this.pathVariable = pathVariable;
    }
}

