/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.model.body;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.github.damianwajser.model.details.DetailField;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

public abstract class Body {
    @JsonIgnore
    private Method method;
    @JsonIgnore
    private Class<?> parametrizedClass;
    @JsonUnwrapped
    private Collection<DetailField> fields = new ArrayList<DetailField>();
    private JsonSchema jsonSchema;

    public Body(Method m, Class<?> controllerClass) {
        this.method = m;
        this.parametrizedClass = controllerClass;
        this.fields = this.buildFields();
        this.setJsonSchema(this.fillJsonSchema());
    }

    protected abstract JsonSchema fillJsonSchema();

    protected abstract Collection<DetailField> buildFields();

    public Collection<DetailField> getFields() {
        return this.fields;
    }

    protected Method getMethod() {
        return this.method;
    }

    protected Class<?> getParametrizedClass() {
        return this.parametrizedClass;
    }

    public JsonSchema getJsonSchema() {
        return this.jsonSchema;
    }

    public void setJsonSchema(JsonSchema jsonSchema) {
        this.jsonSchema = jsonSchema;
    }
}

