/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.model.details.strategys;

import com.github.damianwajser.model.details.strategys.CollectionStrategy;
import com.github.damianwajser.model.details.strategys.DetailFieldStrategy;
import com.github.damianwajser.model.details.strategys.impl.ModelStrategy;
import com.github.damianwajser.model.details.strategys.impl.PrimitiveStrategy;
import com.github.damianwajser.utils.ReflectionUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DetailFieldCreatedStrategyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetailFieldCreatedStrategyFactory.class);

    private DetailFieldCreatedStrategyFactory() {
    }

    public static DetailFieldStrategy getCreationStrategy(Type type, Optional<Class<?>> parametrizedClass) {
        LOGGER.debug("seleccionando strategyField: " + type.getTypeName());
        DetailFieldStrategy strategy = null;
        if (type != null) {
            strategy = ParameterizedType.class.isAssignableFrom(type.getClass()) ? DetailFieldCreatedStrategyFactory.getGenericParameterStrategy(type, strategy) : (!ReflectionUtils.isJDKClass(type) ? new ModelStrategy(ReflectionUtils.getRealType(type, parametrizedClass).get()) : new PrimitiveStrategy(type));
        }
        LOGGER.info("Se selecciono strategy " + strategy);
        return strategy;
    }

    private static DetailFieldStrategy getGenericParameterStrategy(Type type, DetailFieldStrategy strategy) {
        Optional<Class<?>> genericClazz = ReflectionUtils.getClass(((ParameterizedType)type).getRawType());
        Type genericType = ReflectionUtils.getGenericType((ParameterizedType)type).orElseThrow(RuntimeException::new);
        strategy = Iterable.class.isAssignableFrom(genericClazz.get()) ? new CollectionStrategy(genericType) : new ModelStrategy(genericType);
        return strategy;
    }
}

