/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.model.details.strategys.impl;

import com.github.damianwajser.model.details.DetailField;
import com.github.damianwajser.model.details.strategys.DetailFieldCreatedStrategyFactory;
import com.github.damianwajser.model.details.strategys.DetailFieldStrategy;
import com.github.damianwajser.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

public class ModelStrategy
extends DetailFieldStrategy {
    public ModelStrategy(Type type) {
        super(type);
    }

    @Override
    public Collection<DetailField> createDetailField(boolean isRequest) {
        ArrayList<DetailField> detailFields = new ArrayList<DetailField>();
        Optional<Class<?>> clazz = ReflectionUtils.getClass(this.getType());
        while (clazz.isPresent()) {
            detailFields.addAll(this.createDetail(clazz.get(), isRequest));
            clazz = Optional.ofNullable(clazz.get().getSuperclass());
        }
        return detailFields;
    }

    private Collection<DetailField> createDetail(Class<?> clazz, boolean isRequest) {
        ArrayList<DetailField> detailFields = new ArrayList();
        if (!Iterable.class.isAssignableFrom(clazz)) {
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Optional<DetailField> detail;
                Field field = fieldArray[n2];
                if (!Modifier.isStatic(field.getModifiers()) && (detail = this.createDetail(field, isRequest)).isPresent()) {
                    detailFields.add(detail.get());
                }
                ++n2;
            }
        } else {
            detailFields = DetailFieldCreatedStrategyFactory.getCreationStrategy(this.getType(), Optional.empty()).createDetailField(isRequest);
        }
        return detailFields;
    }
}

