/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.model.validators;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class Validator {
    private Annotation annotation;

    public Validator(Annotation annotation) {
        this.annotation = annotation;
    }

    public String getName() {
        return this.annotation.annotationType().getSimpleName();
    }

    protected Annotation getAnnotation() {
        return this.annotation;
    }

    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable((String)AnnotationUtils.getValue((Annotation)this.annotation, (String)"message"));
    }

    @JsonGetter(value="message")
    public String getMessageStr() {
        return this.getMessage().orElse("");
    }
}

