/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.model.validators;

import com.github.damianwajser.model.validators.Validator;
import com.github.damianwajser.model.validators.impl.DefaultValidator;
import com.github.damianwajser.model.validators.impl.PatternValidator;
import com.github.damianwajser.model.validators.impl.RangeValidator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public final class ValidatorFactory {
    private static List<String> validatorsPackage = Arrays.asList("javax.validation.constraints", "hibernate-validator");

    private ValidatorFactory() {
    }

    public static Optional<Collection<Validator>> getValidations(Field field) {
        Optional<Collection<Validator>> validations = Optional.empty();
        Annotation[] annotations = field.getDeclaredAnnotations();
        if (annotations.length > 0) {
            validations = Optional.ofNullable(ValidatorFactory.getValidators(annotations));
        }
        return validations;
    }

    private static Collection<Validator> getValidators(Annotation[] annotations) {
        ArrayList<Validator> validations = new ArrayList<Validator>();
        for (Annotation annotation : annotations) {
            ValidatorFactory.getValidator(annotation).ifPresent(v -> validations.add((Validator)v));
        }
        return validations;
    }

    private static Optional<Validator> getValidator(Annotation annotation) {
        Validator validator = null;
        if (ValidatorFactory.isValidable(annotation)) {
            validator = annotation instanceof Range || annotation instanceof Length ? new RangeValidator(annotation) : (annotation instanceof Pattern ? new PatternValidator(annotation) : new DefaultValidator(annotation));
        }
        return Optional.ofNullable(validator);
    }

    private static boolean isValidable(Annotation annotation) {
        Package p = annotation.annotationType().getPackage();
        return p.getName() != null && validatorsPackage.contains(p.getImplementationTitle()) || validatorsPackage.contains(p.getName());
    }
}

