/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.builders.json;

import com.github.damianwajser.controller.OptionsController;
import com.github.damianwajser.model.CollectionResources;
import com.github.damianwajser.model.Endpoint;
import com.github.damianwajser.model.details.response.DetailFieldResponseFactory;
import com.github.damianwajser.model.details.strategys.DetailFieldStrategy;
import com.github.damianwajser.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

public class ResourcesBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourcesBuilder.class);
    private static ResourcesBuilder instance;
    private List<Object> controllers;
    private CollectionResources resources;

    private ResourcesBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized ResourcesBuilder getInstance() {
        if (instance != null) return instance;
        Class<ResourcesBuilder> clazz = ResourcesBuilder.class;
        synchronized (ResourcesBuilder.class) {
            if (instance != null) return instance;
            instance = new ResourcesBuilder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void init() {
        this.controllers = new ArrayList<Object>();
        this.resources = new CollectionResources();
    }

    public void build(ApplicationContext context) {
        this.init(context);
        this.buildEndpoints(this.controllers);
    }

    public void build(List<Object> controllers) {
        this.init();
        this.controllers = controllers;
        this.buildEndpoints(controllers);
    }

    private void buildEndpoints(Iterable<Object> controllers) {
        controllers.forEach(c -> {
            List<Method> methods = Arrays.asList(c.getClass().getMethods()).stream().filter(m -> ReflectionUtils.containsRequestAnnotation(m) && !m.getDeclaringClass().getPackage().getName().startsWith("org.springframework.boot.autoconfigure.web") && !m.getDeclaringClass().equals(OptionsController.class)).collect(Collectors.toList());
            LOGGER.debug("Se analizan los siguientes endpoints: {}", methods);
            methods.forEach(m -> {
                String relativeUrl = this.getRelativeUrl((Method)m);
                Endpoint endpoint = new Endpoint(relativeUrl, (Method)m, c);
                if (!endpoint.getHttpMethod().equals(HttpMethod.OPTIONS.toString())) {
                    LOGGER.debug("se crearon los siguientes Endpoints: {}", (Object)endpoint);
                    this.resources.addEndpoint(endpoint);
                }
            });
        });
    }

    private String getRelativeUrl(Method m) {
        StringBuilder relativeUrl = new StringBuilder();
        ReflectionUtils.filterRequestMappingAnnontations(m).findFirst().ifPresent(annotation -> {
            RequestMapping a;
            Optional<String[]> value = RequestMapping.class.isAssignableFrom(annotation.getClass()) ? Optional.ofNullable((a = (RequestMapping)annotation).path().length == 0 ? a.value() : a.path()) : Optional.ofNullable((String[])AnnotationUtils.getValue((Annotation)annotation));
            value.ifPresent(v -> relativeUrl.append(Arrays.asList(v).stream().findFirst().orElse("")));
        });
        return relativeUrl.toString();
    }

    private void init(ApplicationContext context) {
        this.init();
        LOGGER.debug("Get All ExceptionHandlers");
        List<Object> exceptionsHandlers = ReflectionUtils.proxyToObject(context.getBeansWithAnnotation(ControllerAdvice.class).values());
        LOGGER.debug("Get All RestController");
        exceptionsHandlers.forEach(this::buildHttpCodes);
        this.controllers.addAll(ReflectionUtils.proxyToObject(context.getBeansWithAnnotation(RestController.class).values()));
        LOGGER.debug("Get All Controller");
        this.controllers.addAll(ReflectionUtils.proxyToObject(context.getBeansWithAnnotation(Controller.class).values()));
    }

    private void buildHttpCodes(Object h) {
        Arrays.asList(h.getClass().getDeclaredMethods()).stream().filter(m -> m.isAnnotationPresent(ExceptionHandler.class) && m.isAnnotationPresent(ResponseStatus.class)).forEach(m -> {
            ResponseStatus status = m.getAnnotation(ResponseStatus.class);
            Type returnType = m.getGenericReturnType();
            DetailFieldStrategy strategy = null;
            strategy = DetailFieldResponseFactory.getCreationStrategy(returnType, m.getDeclaringClass());
            this.resources.addHttpCode(status.value().value(), strategy.createDetailField(false));
        });
    }

    public CollectionResources getResources() {
        return this.resources;
    }

    public SortedSet<String> getEnpoints() {
        return this.resources.getEndpointsList();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

