/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.builders.raml;

import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.github.damianwajser.builders.raml.Raml;
import com.github.damianwajser.builders.raml.model.BodyRaml;
import com.github.damianwajser.builders.raml.model.QueryParameterRaml;
import com.github.damianwajser.builders.raml.model.ResourceMethodRaml;
import com.github.damianwajser.builders.raml.model.ResourceRaml;
import com.github.damianwajser.model.CollectionResources;
import com.github.damianwajser.model.Endpoint;
import com.github.damianwajser.model.Parameters;
import com.github.damianwajser.model.Resource;
import com.github.damianwajser.model.details.DetailField;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamlBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RamlBuilder.class);
    private CollectionResources resources;

    public RamlBuilder(CollectionResources resources) {
        this.resources = resources;
    }

    public Raml build() {
        return this.getResourceRaml(this.resources);
    }

    private Raml getResourceRaml(CollectionResources resources) {
        Raml raml = new Raml("e-BookMobile API", "http://api.e-bookmobile.com/{version}", "v1");
        ResourceRaml root = new ResourceRaml();
        resources.getResources().forEach((path, resource) -> this.getEndpointsRaml((String)path, root, (Resource)resource, resources.getHttpCodes()));
        raml.setResources(root);
        return raml;
    }

    private void getEndpointsRaml(String path, ResourceRaml root, Resource resource, Map<Integer, List<DetailField>> httpCodes) {
        ResourceRaml raml = new ResourceRaml();
        if (resource != null && resource.getEndpoints() != null) {
            resource.getEndpoints().forEach(e -> {
                List<Parameters> params = e.getPathVariable().getParams();
                if (params != null && !params.isEmpty()) {
                    String realPath = "/{" + params.get(0).getName() + "}";
                    raml.add(realPath, this.getMethods((Endpoint)e, httpCodes));
                    this.addBodyRequest(raml, (Endpoint)e, realPath);
                } else if (e.getRelativeUrl().equals("/") || e.getRelativeUrl().isEmpty()) {
                    LOGGER.info("agregando el path: {}, relative: {}", (Object)path, (Object)e.getRelativeUrl());
                    root.add(path, this.getMethods((Endpoint)e, httpCodes));
                    this.addBodyRequest(root, (Endpoint)e, path);
                } else {
                    LOGGER.info("agregando el path: {}, relative: {}", (Object)path, (Object)e.getRelativeUrl());
                    raml.add(e.getRelativeUrl(), this.getMethods((Endpoint)e, httpCodes));
                    this.addBodyRequest(raml, (Endpoint)e);
                }
            });
            root.add(path, raml);
        }
    }

    private void addBodyRequest(ResourceRaml raml, Endpoint e) {
        this.addBodyRequest(raml, e, null);
    }

    private void addBodyRequest(ResourceRaml raml, Endpoint e, String path) {
        if (e.getBodyRequest() != null && e.getBodyRequest().getFields() != null) {
            raml.add(path == null ? e.getRelativeUrl() : path, this.getRealBody(e.getBodyRequest().getClassParameter().orElse(null), e.getBodyRequest().getJsonSchema()));
        }
    }

    private ResourceRaml getMethods(Endpoint e, Map<Integer, List<DetailField>> httpCodes) {
        ResourceRaml methods = new ResourceRaml();
        ResourceRaml qs = this.buildQueryString(e);
        if (qs.getResource() != null && !qs.getResource().isEmpty()) {
            methods.add(e.getHttpMethod(), qs);
        }
        methods.add(e.getHttpMethod(), this.buildBody(e, httpCodes));
        return methods;
    }

    private ResourceRaml buildBody(Endpoint e, Map<Integer, List<DetailField>> httpCodes) {
        ResourceRaml body = new ResourceRaml();
        ResourceRaml bodyResponse = new ResourceRaml();
        body.add("200", this.getRealBody(e.getBodyResponse().getClassParameter().orElse(null), e.getBodyResponse().getJsonSchema()));
        bodyResponse.add("responses", body);
        return bodyResponse;
    }

    private ResourceRaml getRealBody(Class<?> example, JsonSchema jsonSchema) {
        ResourceRaml body = new ResourceRaml();
        BodyRaml bodyResource = new BodyRaml(example);
        if (jsonSchema != null) {
            bodyResource.setJsonSchema(jsonSchema);
        }
        body.add("application/json", bodyResource);
        ResourceRaml bodyRaml = new ResourceRaml();
        bodyRaml.add("body", body);
        return bodyRaml;
    }

    private ResourceRaml buildQueryString(Endpoint e) {
        ResourceMethodRaml m = new ResourceMethodRaml();
        e.getQueryString().getParams().forEach(qs -> m.addQueryParameters(qs.getName(), new QueryParameterRaml(qs.getName(), qs.getType(), "", qs.isRequired())));
        return m;
    }
}

