/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.builders.raml.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.github.damianwajser.utils.RandomObjectFiller;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BodyRaml
implements Comparable<BodyRaml> {
    @JsonProperty(value="type")
    private JsonSchema jsonSchema;
    private String example;
    private ObjectMapper mapper = new ObjectMapper();

    public BodyRaml(Class<?> example) {
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        if (example != null) {
            this.example = this.jsonToString(RandomObjectFiller.createAndFill(example));
        }
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public String getJsonSchema() {
        return this.jsonToString(this.jsonSchema);
    }

    private String jsonToString(Object o) {
        try {
            return this.mapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setJsonSchema(JsonSchema jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    @Override
    public int compareTo(BodyRaml o) {
        return CompareToBuilder.reflectionCompare((Object)this, (Object)o);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)true);
    }
}

