/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.controller;

import com.github.damianwajser.builders.json.ResourcesBuilder;
import com.github.damianwajser.builders.raml.RamlBuilder;
import com.github.damianwajser.model.CollectionResources;
import com.github.damianwajser.utils.StringUtils;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@PropertySource(value={"classpath:application.properties"}, ignoreResourceNotFound=true)
public class OptionsController
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptionsController.class);
    @Autowired
    private ApplicationContext context;

    @CrossOrigin(origins={"*"})
    @RequestMapping(value={"/**"}, method={RequestMethod.OPTIONS}, produces={"application/json"}, headers={""})
    public CollectionResources handleResultsJson(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="method") Optional<String> method) {
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS");
        response.addHeader("Access-Control-Allow-Headers", "origin, content-type, accept, x-requested-with");
        response.addHeader("Access-Control-Max-Age", "3600");
        String path = request.getServletPath().equals("/") ? request.getServletPath() : StringUtils.deleteIfEnd(request.getServletPath(), "/");
        LOGGER.info("solicitando JSON: {}", (Object)path);
        CollectionResources resources = ResourcesBuilder.getInstance().getResources();
        return resources.filterPath(path);
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.OPTIONS}, produces={"application/x-yaml"})
    public Object handleResultsYML(HttpServletRequest request, HttpServletResponse response) {
        CollectionResources resource = this.handleResultsJson(request, response, Optional.empty());
        return new RamlBuilder(resource).build();
    }

    @RequestMapping(value={"/endpoints"}, method={RequestMethod.GET})
    public Iterable<String> handleResults() {
        return ResourcesBuilder.getInstance().getEnpoints();
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        try {
            LOGGER.info("Comenzando la creacion de documentacion");
            ResourcesBuilder.getInstance().build(this.context);
        }
        catch (Exception e) {
            LOGGER.error("problemas al crear la documentacion", (Throwable)e);
        }
    }
}

