/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.model;

import com.github.damianwajser.model.Parameters;
import com.github.damianwajser.utils.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathVariable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathVariable.class);
    private List<Parameters> params = new ArrayList<Parameters>();
    private static Pattern pattern = Pattern.compile("\\{[a-zA-Z0-9]*\\}");

    public PathVariable() {
    }

    public PathVariable(Method m, String relativePath) {
        this.params = ReflectionUtils.getPathVariable(m);
        if (!this.params.isEmpty()) {
            Matcher matcher = pattern.matcher(relativePath);
            LOGGER.info("fix path variable: {}", (Object)relativePath);
            for (int i = 0; i < this.params.size(); ++i) {
                if (!matcher.find()) continue;
                String param = matcher.group(0);
                LOGGER.info("param: {}", (Object)param);
                this.params.get(i).setName(param.replaceAll("\\{", "").replaceAll("\\}", ""));
            }
        }
    }

    public List<Parameters> getParams() {
        return this.params;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

