/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.model.body;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.github.damianwajser.model.details.DetailField;
import com.github.damianwajser.utils.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

public abstract class Body {
    @JsonIgnore
    private Method method;
    @JsonIgnore
    private Class<?> parametrizedClass;
    @JsonUnwrapped
    private List<DetailField> fields = new ArrayList<DetailField>();
    private JsonSchema jsonSchema;

    public Body() {
    }

    public Body(Method m, Class<?> controllerClass) {
        this.method = m;
        this.parametrizedClass = controllerClass;
        this.fields = this.buildFields();
        this.setJsonSchema(this.fillJsonSchema());
    }

    protected abstract JsonSchema fillJsonSchema();

    protected abstract List<DetailField> buildFields();

    public List<DetailField> getFields() {
        if (this.fields != null) {
            Collections.sort(this.fields, (f, f1) -> f.getName().compareTo(f1.getName()));
        }
        return this.fields;
    }

    protected Method getMethod() {
        return this.method;
    }

    protected Class<?> getParametrizedClass() {
        return this.parametrizedClass;
    }

    public JsonSchema getJsonSchema() {
        return this.jsonSchema;
    }

    public void setJsonSchema(JsonSchema jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonIgnore
    public Optional<Class<?>> getClassParameter() {
        return ReflectionUtils.getClass(this.getMethod().getGenericReturnType());
    }
}

