/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.model.details.strategys;

import com.github.damianwajser.model.details.strategys.CollectionStrategy;
import com.github.damianwajser.model.details.strategys.DetailFieldStrategy;
import com.github.damianwajser.model.details.strategys.impl.ModelStrategy;
import com.github.damianwajser.model.details.strategys.impl.PrimitiveStrategy;
import com.github.damianwajser.utils.ReflectionUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DetailFieldCreatedStrategyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetailFieldCreatedStrategyFactory.class);

    private DetailFieldCreatedStrategyFactory() {
    }

    public static DetailFieldStrategy getCreationStrategy(Type type, Optional<Class<?>> parametrizedClass) {
        DetailFieldStrategy strategy = null;
        if (type != null) {
            LOGGER.debug("seleccionando strategyField: {}", (Object)type.getTypeName());
            if (ParameterizedType.class.isAssignableFrom(type.getClass()) || TypeVariable.class.isAssignableFrom(type.getClass())) {
                LOGGER.debug("Es una clase parametrizada");
                strategy = DetailFieldCreatedStrategyFactory.getGenericParameterStrategy(type, parametrizedClass);
            } else if (!ReflectionUtils.isJDKClass(type)) {
                LOGGER.debug("Es una clase de modelo {}", (Object)type);
                strategy = new ModelStrategy(ReflectionUtils.getRealType(type, parametrizedClass).orElse(null));
            } else {
                LOGGER.debug("Es una clase primitiva {}", (Object)type);
                strategy = new PrimitiveStrategy(type);
            }
        }
        LOGGER.info("Se selecciono strategy {}", strategy);
        return strategy;
    }

    private static DetailFieldStrategy getGenericParameterStrategy(Type type, Optional<Class<?>> parametrizableClass) {
        DetailFieldStrategy strategy = null;
        Optional<Object> genericType = Optional.empty();
        if (parametrizableClass.isPresent()) {
            genericType = ReflectionUtils.getRealType(type, parametrizableClass.get());
        }
        LOGGER.debug("Clase generica : {}, para la clase:{}, del tipo: {}", new Object[]{parametrizableClass.orElse(null), genericType, type});
        strategy = Iterable.class.isAssignableFrom(ReflectionUtils.getClass(type).orElse(null)) ? (parametrizableClass.isPresent() ? new CollectionStrategy(genericType.orElse(null)) : new ModelStrategy(genericType.orElse(null))) : new ModelStrategy(genericType.orElse(null));
        return strategy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

