/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.model.validators;

import com.github.damianwajser.model.validators.Validator;
import com.github.damianwajser.model.validators.impl.DefaultValidator;
import com.github.damianwajser.model.validators.impl.PatternValidator;
import com.github.damianwajser.model.validators.impl.RangeValidator;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public final class ValidatorFactory {
    private static List<String> validatorsPackage = Arrays.asList("javax.validation.constraints", "hibernate-validator");

    private ValidatorFactory() {
    }

    public static Optional<List<Validator>> getValidations(PropertyDescriptor fieldDescriptor, Optional<Field> field) {
        List<Annotation> annotationField;
        Optional<List<Validator>> validations = Optional.empty();
        validations = ValidatorFactory.fillValidations(fieldDescriptor, validations);
        if (field.isPresent() && !(annotationField = Arrays.asList(field.get().getAnnotations())).isEmpty()) {
            validations = ValidatorFactory.completeValidations(validations, annotationField);
        }
        return validations;
    }

    private static Optional<List<Validator>> completeValidations(Optional<List<Validator>> validations, List<Annotation> annotationField) {
        List<Validator> validatorsField = ValidatorFactory.getValidators(annotationField);
        if (validations.isPresent()) {
            validations.get().addAll(validatorsField);
        } else {
            validations = Optional.ofNullable(validatorsField);
        }
        return validations.get().isEmpty() ? Optional.empty() : validations;
    }

    private static Optional<List<Validator>> fillValidations(PropertyDescriptor fieldDescriptor, Optional<List<Validator>> validations) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Method setter = fieldDescriptor.getWriteMethod();
        Method getter = fieldDescriptor.getReadMethod();
        if (setter != null) {
            annotations.addAll(Arrays.asList(setter.getAnnotations()));
        }
        if (getter != null) {
            annotations.addAll(Arrays.asList(getter.getAnnotations()));
        }
        if (!annotations.isEmpty()) {
            validations = Optional.ofNullable(ValidatorFactory.getValidators(annotations));
        }
        return validations;
    }

    private static List<Validator> getValidators(List<Annotation> annotations) {
        ArrayList<Validator> validations = new ArrayList<Validator>();
        for (Annotation annotation : annotations) {
            ValidatorFactory.getValidator(annotation).ifPresent(validations::add);
        }
        return validations;
    }

    private static Optional<Validator> getValidator(Annotation annotation) {
        Validator validator = null;
        if (ValidatorFactory.isValidable(annotation)) {
            validator = annotation instanceof Range || annotation instanceof Length ? new RangeValidator(annotation) : (annotation instanceof Pattern ? new PatternValidator(annotation) : new DefaultValidator(annotation));
        }
        return Optional.ofNullable(validator);
    }

    private static boolean isValidable(Annotation annotation) {
        Package p = annotation.annotationType().getPackage();
        return p.getName() != null && validatorsPackage.contains(p.getImplementationTitle()) || validatorsPackage.contains(p.getName());
    }
}

