/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.utils;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.github.damianwajser.utils.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonSchemmaUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonSchemmaUtils.class);

    private JsonSchemmaUtils() {
    }

    private static Optional<JsonSchema> getSchemma(Optional<Class<?>> clazz) {
        Optional<JsonSchema> opt = Optional.empty();
        if (clazz.isPresent()) {
            opt = JsonSchemmaUtils.getSchemma(clazz.get());
        }
        return opt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Optional<JsonSchema> getSchemma(Class<?> clazz) {
        boolean iterable;
        ObjectMapper mapper = new ObjectMapper();
        Optional<JsonSchema> schema = Optional.empty();
        SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
        Optional<Class<?>> realClazz = ReflectionUtils.getGenericClass(clazz);
        boolean bl = iterable = Iterable.class.isAssignableFrom(clazz) && realClazz.isPresent();
        if (iterable) {
            clazz = realClazz.get();
        }
        try {
            mapper.acceptJsonFormatVisitor(clazz, (JsonFormatVisitorWrapper)visitor);
            JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(mapper);
            schema = Optional.ofNullable(schemaGen.generateSchema(clazz));
            if (!iterable) return schema;
        }
        catch (JsonMappingException e) {
            LOGGER.error("Se produjo un error al crear el JsonSchemma para la clase {}", (Object)clazz.getSimpleName(), (Object)e);
        }
        return schema;
    }

    public static Optional<JsonSchema> getSchemma(Method m, Class<?> controller, boolean isRequest) {
        Optional<JsonSchema> schemma = isRequest ? JsonSchemmaUtils.getRequestSchemma(m, controller) : JsonSchemmaUtils.getResponseSchemma(m, controller);
        return schemma;
    }

    private static Optional<JsonSchema> getResponseSchemma(Method m, Class<?> parametrizedClass) {
        Optional<JsonSchema> schemma = Optional.empty();
        Optional<Type> returnType = ReflectionUtils.getRealType(m.getGenericReturnType(), parametrizedClass);
        if (returnType.isPresent()) {
            Optional<Class<?>> realClass = ReflectionUtils.getClass(returnType.get());
            if (realClass.isPresent()) {
                if (Iterable.class.isAssignableFrom(realClass.get()) && ParameterizedType.class.isAssignableFrom(returnType.get().getClass())) {
                    returnType = ReflectionUtils.getGenericType((ParameterizedType)returnType.get());
                }
                schemma = JsonSchemmaUtils.getSchemma(ReflectionUtils.getClass(returnType.orElse(null)).orElse(realClass.get()));
            } else {
                LOGGER.error("No existe una real class para: {}", returnType);
            }
        }
        return schemma;
    }

    private static Optional<JsonSchema> getRequestSchemma(Method m, Class<?> controller) {
        List<Parameter> p = ReflectionUtils.getParametersBody(m);
        Optional<JsonSchema> schemma = Optional.empty();
        if (!p.isEmpty()) {
            Optional<Class<?>> c;
            Optional<Type> t = ReflectionUtils.getRealType(p.get(0).getParameterizedType(), controller);
            schemma = t.isPresent() ? ((c = ReflectionUtils.getClass(t.get())).isPresent() ? JsonSchemmaUtils.getSchemma(c.get()) : JsonSchemmaUtils.getSchemma(t.getClass())) : JsonSchemmaUtils.getSchemma(ReflectionUtils.getClass(p.get(0).getParameterizedType()));
        }
        return schemma;
    }
}

