/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Random;
import java.util.UUID;

public final class RandomObjectFiller {
    private static Random random = new Random();

    private RandomObjectFiller() {
    }

    public static Object createAndFill(Class<?> clazz) {
        Object instance = null;
        try {
            instance = clazz.newInstance();
            for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = c.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    field.setAccessible(true);
                    Object value = RandomObjectFiller.getRandomValueForField(field);
                    field.set(instance, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instance;
    }

    private static Object getRandomValueForField(Field field) throws Exception {
        Class<Class> type = field.getType();
        if (type.isEnum()) {
            ?[] enumValues = type.getEnumConstants();
            return enumValues[random.nextInt(enumValues.length)];
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return random.nextInt();
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return random.nextLong();
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return random.nextDouble();
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf(random.nextFloat());
        }
        if (type.equals(String.class)) {
            return UUID.randomUUID().toString();
        }
        if (type.equals(BigInteger.class)) {
            return BigInteger.valueOf(random.nextInt());
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return random.nextInt() % 2 == 0;
        }
        if (type.isAssignableFrom(Class.class)) {
            return type.getClass();
        }
        if (Iterable.class.isAssignableFrom(type)) {
            return Collections.EMPTY_LIST;
        }
        return RandomObjectFiller.createAndFill(type);
    }
}

