/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.aggregator;

import com.github.dandelion.datatables.core.asset.CssResource;
import com.github.dandelion.datatables.core.asset.JsResource;
import com.github.dandelion.datatables.core.asset.ResourceType;
import com.github.dandelion.datatables.core.asset.WebResources;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.util.ResourceHelper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceAggregator {
    private static Logger logger = LoggerFactory.getLogger(ResourceAggregator.class);

    public static void processAggregation(WebResources webResources, HtmlTable table) {
        logger.debug("Processing aggregation, using configuration {}", (Object)table.getTableProperties().getAggregatorMode());
        switch (table.getTableProperties().getAggregatorMode()) {
            case ALL: {
                ResourceAggregator.aggregateAll(webResources);
                break;
            }
            case PLUGINS_JS: {
                ResourceAggregator.aggregatePluginsJs(webResources);
                break;
            }
            case PLUGINS_CSS: {
                ResourceAggregator.aggregatePluginsCss(webResources);
                break;
            }
        }
    }

    public static void aggregateAll(WebResources webResources) {
        if (webResources.getJavascripts().size() > 0) {
            String jsResourceName = "datatables-aggr-" + ResourceHelper.getRamdomNumber() + ".js";
            JsResource aggregateJsFile = new JsResource(ResourceType.AGGREGATE, jsResourceName);
            String aggregatedJsContent = "";
            for (Map.Entry<String, JsResource> entry : webResources.getJavascripts().entrySet()) {
                aggregatedJsContent = aggregatedJsContent + entry.getValue().getContent();
            }
            aggregatedJsContent = aggregatedJsContent + webResources.getMainJsFile().getContent();
            aggregateJsFile.setContent(aggregatedJsContent);
            webResources.getJavascripts().clear();
            webResources.setMainJsFile(aggregateJsFile);
        }
        if (webResources.getStylesheets().size() > 1) {
            String cssResourceName = "datatables-aggr-" + ResourceHelper.getRamdomNumber() + ".css";
            CssResource aggregateCssFile = new CssResource(cssResourceName);
            String aggregatedCssContent = "";
            for (Map.Entry<String, Object> entry : webResources.getStylesheets().entrySet()) {
                aggregatedCssContent = aggregatedCssContent + ((CssResource)entry.getValue()).getContent();
            }
            aggregateCssFile.setContent(aggregatedCssContent);
            webResources.getStylesheets().clear();
            webResources.getStylesheets().put(aggregateCssFile.getName(), aggregateCssFile);
        }
        logger.debug("Aggregation (ALL) completed");
    }

    public static void aggregatePluginsJs(WebResources webResources) {
        String jsResourceName = "datatables-aggr-plugins-" + ResourceHelper.getRamdomNumber() + ".js";
        JsResource aggregatePluginsJsFile = new JsResource(ResourceType.AGGREGATE, jsResourceName);
        String aggregatedJsContent = "";
        for (Map.Entry<String, JsResource> entry : webResources.getJavascripts().entrySet()) {
            if (entry.getValue().getType().equals((Object)ResourceType.PLUGIN)) {
                aggregatedJsContent = aggregatedJsContent + entry.getValue().getContent();
            }
            webResources.getJavascripts().remove(entry.getKey());
        }
        aggregatePluginsJsFile.setContent(aggregatedJsContent);
        webResources.getJavascripts().put(aggregatePluginsJsFile.getName(), aggregatePluginsJsFile);
        logger.debug("Aggregation (PLUGINS_JS) completed");
    }

    public static void aggregatePluginsCss(WebResources webResources) {
        String cssResourceName = "datatables-aggr-plugins-" + ResourceHelper.getRamdomNumber() + ".css";
        CssResource aggregatePluginsCssFile = new CssResource(cssResourceName);
        String aggregatedCssContent = "";
        for (Map.Entry<String, CssResource> entry : webResources.getStylesheets().entrySet()) {
            if (entry.getValue().getType().equals((Object)ResourceType.PLUGIN)) {
                aggregatedCssContent = aggregatedCssContent + entry.getValue().getContent();
            }
            webResources.getStylesheets().remove(entry.getKey());
        }
        aggregatePluginsCssFile.setContent(aggregatedCssContent);
        webResources.getStylesheets().put(aggregatePluginsCssFile.getName(), aggregatePluginsCssFile);
        logger.debug("Aggregation (PLUGINS_CSS) completed");
    }
}

