/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.ajax;

import com.github.dandelion.datatables.core.ajax.ColumnDef;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public final class DatatablesCriterias {
    private String search;
    private Integer displayStart;
    private Integer displaySize;
    private List<ColumnDef> columnDefs;
    private List<ColumnDef> sortingColumnDefs;
    private Integer internalCounter;

    public DatatablesCriterias() {
    }

    public DatatablesCriterias(String search, Integer displayStart, Integer displaySize, List<ColumnDef> columnDefs, List<ColumnDef> sortingColumnDefs, Integer internalCounter) {
        this.search = search;
        this.displayStart = displayStart;
        this.displaySize = displaySize;
        this.columnDefs = columnDefs;
        this.sortingColumnDefs = sortingColumnDefs;
        this.internalCounter = internalCounter;
    }

    public Integer getDisplayStart() {
        return this.displayStart;
    }

    public Integer getDisplaySize() {
        return this.displaySize;
    }

    public String getSearch() {
        return this.search;
    }

    public Integer getInternalCounter() {
        return this.internalCounter;
    }

    public List<ColumnDef> getColumnDefs() {
        return this.columnDefs;
    }

    public List<ColumnDef> getSortingColumnDefs() {
        return this.sortingColumnDefs;
    }

    public Boolean hasOneFilterableColumn() {
        for (ColumnDef columnDef : this.columnDefs) {
            if (!columnDef.isFilterable()) continue;
            return true;
        }
        return false;
    }

    public Boolean hasOneFilteredColumn() {
        for (ColumnDef columnDef : this.columnDefs) {
            if (!StringUtils.isNotBlank((String)columnDef.getSearch())) continue;
            return true;
        }
        return false;
    }

    public Boolean hasOneSortedColumn() {
        return !this.sortingColumnDefs.isEmpty();
    }

    public static DatatablesCriterias getFromRequest(HttpServletRequest request) {
        if (request != null) {
            int i;
            String sSearch = request.getParameter("sSearch");
            String sEcho = request.getParameter("sEcho");
            String sDisplayStart = request.getParameter("iDisplayStart");
            String sDisplayLength = request.getParameter("iDisplayLength");
            Integer iEcho = Integer.parseInt(sEcho);
            Integer iDisplayStart = Integer.parseInt(sDisplayStart);
            Integer iDisplayLength = Integer.parseInt(sDisplayLength);
            Integer colNumber = Integer.parseInt(request.getParameter("iColumns"));
            Integer sortingColNumber = request.getParameter("iSortingCols") != null ? Integer.parseInt(request.getParameter("iSortingCols")) : 0;
            ArrayList<ColumnDef> columnDefs = new ArrayList<ColumnDef>();
            LinkedList<ColumnDef> sortingColumnDefs = new LinkedList<ColumnDef>();
            for (i = 0; i < colNumber; ++i) {
                ColumnDef columnDef = new ColumnDef();
                columnDef.setName(request.getParameter("mDataProp_" + i));
                columnDef.setFilterable(Boolean.parseBoolean(request.getParameter("bSearchable_" + i)));
                columnDef.setSortable(Boolean.parseBoolean(request.getParameter("bSortable_" + i)));
                columnDef.setSearch(request.getParameter("sSearch_" + i));
                columnDefs.add(columnDef);
            }
            for (i = 0; i < sortingColNumber; ++i) {
                Integer sortingCol = Integer.parseInt(request.getParameter("iSortCol_" + i));
                ColumnDef sortedColumnDef = (ColumnDef)columnDefs.get(sortingCol);
                String sortingColDirection = request.getParameter("sSortDir_" + i);
                sortedColumnDef.setSortDirection(ColumnDef.SortDirection.valueOf(sortingColDirection.toUpperCase()));
                sortingColumnDefs.add(sortedColumnDef);
            }
            return new DatatablesCriterias(sSearch, iDisplayStart, iDisplayLength, columnDefs, sortingColumnDefs, iEcho);
        }
        return null;
    }

    public String toString() {
        return "DatatablesCriterias [search=" + this.search + ", displayStart=" + this.displayStart + ", displaySize=" + this.displaySize + ", internalCounter=" + this.internalCounter + ", columnDefs=" + this.columnDefs + "]";
    }
}

