/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.compressor;

import com.github.dandelion.datatables.core.asset.CssResource;
import com.github.dandelion.datatables.core.asset.JsResource;
import com.github.dandelion.datatables.core.asset.ResourceType;
import com.github.dandelion.datatables.core.asset.WebResources;
import com.github.dandelion.datatables.core.compressor.ResourceCompressorDelegate;
import com.github.dandelion.datatables.core.exception.BadConfigurationException;
import com.github.dandelion.datatables.core.exception.CompressionException;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.util.ReflectHelper;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCompressor {
    private static Logger logger = LoggerFactory.getLogger(ResourceCompressor.class);

    public static void processCompression(WebResources webResources, HtmlTable table) throws BadConfigurationException, CompressionException {
        logger.debug("Processing compression, using class {} and mode {}", (Object)table.getTableProperties().getCompressorClassName(), (Object)table.getTableProperties().getCompressorMode());
        ResourceCompressorDelegate compressorHelper = new ResourceCompressorDelegate(table);
        if (ReflectHelper.canBeUsed(table.getTableProperties().getCompressorClassName()).booleanValue()) {
            switch (table.getTableProperties().getCompressorMode()) {
                case ALL: {
                    ResourceCompressor.compressJavascript(webResources, compressorHelper);
                    ResourceCompressor.compressMainJavascript(webResources, compressorHelper);
                    ResourceCompressor.compressStylesheet(webResources, compressorHelper);
                    break;
                }
                case CSS: {
                    ResourceCompressor.compressStylesheet(webResources, compressorHelper);
                    break;
                }
                case JS: {
                    ResourceCompressor.compressJavascript(webResources, compressorHelper);
                    ResourceCompressor.compressMainJavascript(webResources, compressorHelper);
                    break;
                }
            }
            logger.debug("Compression completed");
        } else {
            logger.warn("The compressor class {} hasn't been found in the classpath. Compression is disabled.", (Object)table.getTableProperties().getCompressorClassName());
        }
    }

    private static void compressJavascript(WebResources webResources, ResourceCompressorDelegate helper) throws BadConfigurationException, CompressionException {
        TreeMap<String, JsResource> newJavascripts = new TreeMap<String, JsResource>();
        for (Map.Entry<String, JsResource> oldEntry : webResources.getJavascripts().entrySet()) {
            JsResource minimifiedResource = oldEntry.getValue();
            minimifiedResource.setContent(helper.getCompressedJavascript(oldEntry.getValue().getContent()));
            minimifiedResource.setName(oldEntry.getValue().getName().replace(".js", ".min.js"));
            minimifiedResource.setType(ResourceType.MINIMIFIED);
            newJavascripts.put(minimifiedResource.getName(), minimifiedResource);
        }
        webResources.setJavascripts(newJavascripts);
    }

    private static void compressMainJavascript(WebResources webResources, ResourceCompressorDelegate helper) throws BadConfigurationException, CompressionException {
        JsResource minMainJsFile = webResources.getMainJsFile();
        minMainJsFile.setContent(helper.getCompressedJavascript(minMainJsFile.getContent()));
        minMainJsFile.setName(minMainJsFile.getName().replace(".js", ".min.js"));
        minMainJsFile.setType(ResourceType.MINIMIFIED);
        webResources.setMainJsFile(minMainJsFile);
    }

    private static void compressStylesheet(WebResources webResources, ResourceCompressorDelegate helper) throws BadConfigurationException, CompressionException {
        TreeMap<String, CssResource> newStylesheets = new TreeMap<String, CssResource>();
        for (Map.Entry<String, CssResource> entry : webResources.getStylesheets().entrySet()) {
            CssResource minimifiedResource = entry.getValue();
            minimifiedResource.setContent(helper.getCompressedCss(entry.getValue().getContent()));
            minimifiedResource.setName(entry.getValue().getName().replace(".css", ".min.css"));
            newStylesheets.put(minimifiedResource.getName(), minimifiedResource);
        }
        webResources.setStylesheets(newStylesheets);
    }
}

