/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.compressor;

import com.github.dandelion.datatables.core.exception.BadConfigurationException;
import com.github.dandelion.datatables.core.exception.CompressionException;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.util.ReflectHelper;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCompressorDelegate {
    private static Logger logger = LoggerFactory.getLogger(ResourceCompressorDelegate.class);
    private HtmlTable table;
    private String compressorClassName;

    public ResourceCompressorDelegate(HtmlTable table) {
        this.table = table;
        this.compressorClassName = table.getTableProperties().getCompressorClassName();
        logger.debug("ResourceCompressor loaded. About to use {} implementation", (Object)this.compressorClassName);
    }

    public String getCompressedJavascript(String input) throws BadConfigurationException, CompressionException {
        Class<?> compressorClass = ReflectHelper.getClass(this.compressorClassName);
        logger.debug("Instancing the compressor class {}", compressorClass);
        Object obj = ReflectHelper.getNewInstance(compressorClass);
        logger.debug("Invoking method getCompressedJavascript");
        try {
            return (String)ReflectHelper.invokeMethod(obj, "getCompressedJavascript", new Object[]{this.table, input});
        }
        catch (BadConfigurationException e) {
            if (e.getCause() instanceof InvocationTargetException) {
                throw (CompressionException)((InvocationTargetException)e.getCause()).getTargetException();
            }
            throw e;
        }
    }

    public String getCompressedCss(String input) throws BadConfigurationException, CompressionException {
        Class<?> compressorClass = ReflectHelper.getClass(this.compressorClassName);
        Object obj = ReflectHelper.getNewInstance(compressorClass);
        try {
            return (String)ReflectHelper.invokeMethod(obj, "getCompressedCss", new Object[]{input});
        }
        catch (BadConfigurationException e) {
            if (e.getCause() instanceof InvocationTargetException) {
                throw (CompressionException)((InvocationTargetException)e.getCause()).getTargetException();
            }
            throw e;
        }
    }
}

