/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.export;

import com.github.dandelion.datatables.core.asset.DisplayType;
import com.github.dandelion.datatables.core.exception.ExportException;
import com.github.dandelion.datatables.core.export.AbstractCharExport;
import com.github.dandelion.datatables.core.export.ExportType;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlRow;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.io.IOException;
import java.io.Writer;

public class CsvExport
extends AbstractCharExport {
    private static final DisplayType CURRENT_DISPLAY_TYPE = DisplayType.CSV;
    private static final String SEPARATOR_CHAR = ";";
    private HtmlTable table;

    @Override
    public void initExport(HtmlTable table) {
        this.table = table;
    }

    @Override
    public void processExport(Writer output) throws ExportException {
        StringBuilder buffer = new StringBuilder();
        if (this.table.getExportConfMap().get((Object)ExportType.CSV).getIncludeHeader().booleanValue()) {
            for (HtmlRow row : this.table.getHeadRows()) {
                for (HtmlColumn column : row.getColumns()) {
                    if (!column.getEnabledDisplayTypes().contains((Object)DisplayType.ALL) && !column.getEnabledDisplayTypes().contains((Object)CURRENT_DISPLAY_TYPE)) continue;
                    buffer.append((CharSequence)column.getContent()).append(SEPARATOR_CHAR);
                }
                buffer.append("\n");
            }
        }
        for (HtmlRow row : this.table.getBodyRows()) {
            for (HtmlColumn column : row.getColumns()) {
                if (!column.getEnabledDisplayTypes().contains((Object)DisplayType.ALL) && !column.getEnabledDisplayTypes().contains((Object)CURRENT_DISPLAY_TYPE)) continue;
                buffer.append((CharSequence)column.getContent()).append(SEPARATOR_CHAR);
            }
            buffer.append("\n");
        }
        try {
            output.write(buffer.toString());
        }
        catch (IOException e) {
            throw new ExportException(e);
        }
    }
}

