/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.export;

import com.github.dandelion.datatables.core.exception.BadConfigurationException;
import com.github.dandelion.datatables.core.exception.ExportException;
import com.github.dandelion.datatables.core.export.ExportProperties;
import com.github.dandelion.datatables.core.export.ExportType;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.util.ReflectHelper;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportDelegate {
    private static Logger logger = LoggerFactory.getLogger(ExportDelegate.class);
    private HtmlTable htmlTable;
    private ExportProperties exportProperties;
    private HttpServletRequest request;

    public ExportDelegate(HtmlTable htmlTable, ExportProperties exportProperties, HttpServletRequest request) {
        this.htmlTable = htmlTable;
        this.exportProperties = exportProperties;
        this.request = request;
    }

    public void launchExport() throws ExportException {
        ByteArrayOutputStream stream = null;
        StringWriter writer = null;
        String exportClass = null;
        ExportType exportType = this.htmlTable.getExportProperties().getCurrentExportType();
        exportClass = this.htmlTable.getTableProperties().getExportClass(exportType);
        logger.debug("Export class selected : {}", (Object)exportClass);
        if (!ReflectHelper.canBeUsed(exportClass).booleanValue()) {
            logger.error("Did you forget to add a dependency ?");
            throw new ExportException("Unable to export in " + exportType.toString() + " format");
        }
        if (exportType.equals((Object)ExportType.CSV) || exportType.equals((Object)ExportType.XML)) {
            this.exportProperties.setIsBinaryExport(false);
            writer = new StringWriter();
            try {
                Class<?> klass = ReflectHelper.getClass(exportClass);
                Object obj = ReflectHelper.getNewInstance(klass);
                ReflectHelper.invokeMethod(obj, "initExport", new Object[]{this.htmlTable});
                ReflectHelper.invokeMethod(obj, "processExport", new Object[]{writer});
                this.request.setAttribute("ddl-dt-export-content", (Object)writer.toString());
            }
            catch (BadConfigurationException e) {
                throw new ExportException(e);
            }
        }
        this.exportProperties.setIsBinaryExport(true);
        stream = new ByteArrayOutputStream();
        try {
            Class<?> klass = ReflectHelper.getClass(exportClass);
            Object obj = ReflectHelper.getNewInstance(klass);
            ReflectHelper.invokeMethod(obj, "initExport", new Object[]{this.htmlTable});
            ReflectHelper.invokeMethod(obj, "processExport", new Object[]{stream});
            this.request.setAttribute("ddl-dt-export-content", (Object)stream.toByteArray());
        }
        catch (BadConfigurationException e) {
            throw new ExportException(e);
        }
        this.request.setAttribute("ddl-dt-export-properties", (Object)this.exportProperties);
    }
}

