/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.export;

import java.util.HashMap;
import java.util.Map;

public enum ExportType {
    CSV("csv", "text/csv", 1),
    HTML("html", "text/html", 2),
    XML("xml", "text/xml", 3),
    RTF("rtf", "text/rtf", 4),
    PDF("pdf", "application/pdf", 5),
    XLS("xls", "application/vnd.ms-excel", 6),
    JSON("json", "", 7),
    XLSX("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", 8);

    private String extension;
    private String mimeType;
    private Integer urlParameter;
    private static final Map<Integer, ExportType> map;

    private ExportType(String extension, String mimeType, Integer urlParameter) {
        this.extension = extension;
        this.mimeType = mimeType;
        this.urlParameter = urlParameter;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Integer getUrlParameter() {
        return this.urlParameter;
    }

    public void setUrlParameter(Integer urlParameter) {
        this.urlParameter = urlParameter;
    }

    public static ExportType findByUrlParameter(Integer i) {
        return map.get(i);
    }

    static {
        map = new HashMap<Integer, ExportType>();
        for (ExportType v : ExportType.values()) {
            map.put(v.getUrlParameter(), v);
        }
    }
}

