/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.export;

import com.github.dandelion.datatables.core.exception.ExportException;
import com.github.dandelion.datatables.core.export.AbstractCharExport;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlRow;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;

public class XmlExport
extends AbstractCharExport {
    private HtmlTable table;

    @Override
    public void initExport(HtmlTable table) {
        this.table = table;
    }

    @Override
    public void processExport(Writer output) throws ExportException {
        ArrayList<String> headers = new ArrayList<String>();
        for (HtmlRow row : this.table.getHeadRows()) {
            for (HtmlColumn column : row.getColumns()) {
                headers.add(StringUtils.uncapitalize((String)column.getContent().toString()));
            }
        }
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = null;
        try {
            writer = outputFactory.createXMLStreamWriter(output);
            writer.writeStartDocument("1.0");
            writer.writeStartElement(this.table.getObjectType().toLowerCase() + "s");
            for (HtmlRow row : this.table.getBodyRows()) {
                writer.writeStartElement(this.table.getObjectType().toLowerCase());
                int i = 0;
                for (HtmlColumn column : row.getColumns()) {
                    writer.writeAttribute((String)headers.get(i), column.getContent().toString());
                    ++i;
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new ExportException(e);
        }
        finally {
            try {
                writer.close();
            }
            catch (XMLStreamException e) {
                throw new ExportException(e);
            }
        }
    }
}

