/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension;

import com.github.dandelion.datatables.core.asset.Configuration;
import com.github.dandelion.datatables.core.asset.CssResource;
import com.github.dandelion.datatables.core.asset.JsResource;
import com.github.dandelion.datatables.core.exception.BadConfigurationException;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.generator.AbstractConfigurationGenerator;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractExtension
implements Extension {
    protected StringBuilder beforeAll;
    protected StringBuilder afterAll;
    protected StringBuilder beforeStartDocumentReady;
    protected StringBuilder afterStartDocumentReady;
    protected StringBuilder beforeEndDocumentReady;
    protected List<JsResource> jsResources;
    protected List<CssResource> cssResources;
    protected List<Configuration> confs;
    protected AbstractConfigurationGenerator configGenerator;
    protected Boolean appendRandomNumber = false;
    protected String function;

    @Override
    public abstract String getName();

    @Override
    public abstract String getVersion();

    @Override
    public abstract void setup(HtmlTable var1) throws BadConfigurationException;

    @Override
    public StringBuilder getBeforeAll() {
        return this.beforeAll;
    }

    @Override
    public StringBuilder getAfterAll() {
        return this.afterAll;
    }

    @Override
    public StringBuilder getAfterStartDocumentReady() {
        return this.afterStartDocumentReady;
    }

    @Override
    public StringBuilder getBeforeEndDocumentReady() {
        return this.beforeEndDocumentReady;
    }

    @Override
    public List<JsResource> getJsResources() {
        return this.jsResources;
    }

    @Override
    public void setJsResources(List<JsResource> jsResources) {
        this.jsResources = jsResources;
    }

    @Override
    public List<CssResource> getCssResources() {
        return this.cssResources;
    }

    @Override
    public void setCssResources(List<CssResource> cssResources) {
        this.cssResources = cssResources;
    }

    @Override
    public List<Configuration> getConfs() {
        return this.confs;
    }

    @Override
    public void setConfs(List<Configuration> confs) {
        this.confs = confs;
    }

    @Override
    public void addJsResource(JsResource resource) {
        if (this.jsResources == null) {
            this.jsResources = new LinkedList<JsResource>();
        }
        this.jsResources.add(resource);
    }

    @Override
    public void addCssResource(CssResource resource) {
        if (this.cssResources == null) {
            this.cssResources = new LinkedList<CssResource>();
        }
        this.cssResources.add(resource);
    }

    @Override
    public void addConfiguration(Configuration conf) {
        if (this.confs == null) {
            this.confs = new ArrayList<Configuration>();
        }
        this.confs.add(conf);
    }

    @Override
    public AbstractConfigurationGenerator getConfigGenerator() {
        return this.configGenerator;
    }

    @Override
    public void setConfigGenerator(AbstractConfigurationGenerator configGenerator) {
        this.configGenerator = configGenerator;
    }

    @Override
    public Boolean getAppendRandomNumber() {
        return this.appendRandomNumber;
    }

    @Override
    public void setAppendRandomNumber(Boolean appendRandomNumber) {
        this.appendRandomNumber = appendRandomNumber;
    }

    @Override
    public void appendToBeforeAll(String beforeAll) {
        if (this.beforeAll == null) {
            this.beforeAll = new StringBuilder();
        }
        this.beforeAll.append(beforeAll);
    }

    @Override
    public void appendToBeforeStartDocumentReady(String beforeStartDocumentReady) {
        if (this.beforeStartDocumentReady == null) {
            this.beforeStartDocumentReady = new StringBuilder();
        }
        this.beforeStartDocumentReady.append(beforeStartDocumentReady);
    }

    @Override
    public void appendToAfterStartDocumentReady(String afterStartDocumentReady) {
        if (this.afterStartDocumentReady == null) {
            this.afterStartDocumentReady = new StringBuilder();
        }
        this.afterStartDocumentReady.append(afterStartDocumentReady);
    }

    @Override
    public void appendToBeforeEndDocumentReady(String beforeEndDocumentReady) {
        if (this.beforeEndDocumentReady == null) {
            this.beforeEndDocumentReady = new StringBuilder();
        }
        this.beforeEndDocumentReady.append(beforeEndDocumentReady);
    }

    @Override
    public void appendToAfterAll(String afterAll) {
        if (this.afterAll == null) {
            this.afterAll = new StringBuilder();
        }
        this.afterAll.append(afterAll);
    }

    @Override
    public String getFunction() {
        return this.function;
    }

    @Override
    public void setFunction(String function) {
        this.function = function;
    }
}

