/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension;

import com.github.dandelion.datatables.core.asset.Configuration;
import com.github.dandelion.datatables.core.asset.CssResource;
import com.github.dandelion.datatables.core.asset.JavascriptFunction;
import com.github.dandelion.datatables.core.asset.JavascriptSnippet;
import com.github.dandelion.datatables.core.asset.JsResource;
import com.github.dandelion.datatables.core.asset.ResourceType;
import com.github.dandelion.datatables.core.asset.WebResources;
import com.github.dandelion.datatables.core.exception.BadConfigurationException;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.util.CollectionUtils;
import com.github.dandelion.datatables.core.util.JsonIndentingWriter;
import com.github.dandelion.datatables.core.util.Predicate;
import com.github.dandelion.datatables.core.util.ResourceHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionLoader {
    private static Logger logger = LoggerFactory.getLogger(ExtensionLoader.class);
    private HtmlTable table;
    private JsResource mainJsFile;
    private Map<String, Object> mainConfig;
    private WebResources webResources;

    public ExtensionLoader(HtmlTable table, JsResource mainJsFile, Map<String, Object> mainConfig, WebResources webResources) {
        this.table = table;
        this.mainJsFile = mainJsFile;
        this.mainConfig = mainConfig;
        this.webResources = webResources;
    }

    public void load(List<? extends Extension> extensions) throws BadConfigurationException, IOException {
        if (extensions != null && !extensions.isEmpty()) {
            for (Extension extension : extensions) {
                extension.setup(this.table);
                this.loadJsResources(extension);
                this.loadCssResources(this.table, extension);
                this.loadExternalCssResources(extension);
                this.injectIntoMainJsFile(extension);
                this.injectIntoMainConfiguration(extension);
            }
        }
    }

    private void loadJsResources(Extension extension) throws BadConfigurationException {
        JsResource extensionJsFile = null;
        String resourceName = null;
        if (extension.getJsResources() != null && !extension.getJsResources().isEmpty()) {
            resourceName = extension.getAppendRandomNumber() != false ? extension.getName().toLowerCase() + "-" + this.table.getRandomId() + ".js" : extension.getName().toLowerCase() + ".js";
            extensionJsFile = new JsResource(ResourceType.EXTENSION, resourceName);
            StringBuilder jsContent = new StringBuilder();
            for (JsResource jsResource : extension.getJsResources()) {
                jsContent.append(ResourceHelper.getFileContentFromClasspath(jsResource.getLocation()));
            }
            extensionJsFile.setContent(jsContent.toString());
            this.webResources.getJavascripts().put(extensionJsFile.getName(), extensionJsFile);
        }
    }

    private void loadExternalCssResources(Extension extension) {
        List externalCssResources;
        Predicate<CssResource> isExternalCss = new Predicate<CssResource>(){

            @Override
            public boolean apply(CssResource cssResource) {
                return cssResource.getType().equals((Object)ResourceType.EXTERNAL);
            }
        };
        if (extension.getCssResources() != null && (externalCssResources = (List)CollectionUtils.filter(extension.getCssResources(), isExternalCss)) != null && !externalCssResources.isEmpty()) {
            for (CssResource cssResource : externalCssResources) {
                this.webResources.getStylesheets().put(cssResource.getName(), cssResource);
            }
        }
    }

    private void loadCssResources(HtmlTable table, Extension extension) throws BadConfigurationException {
        CssResource pluginsSourceCssFile = null;
        String resourceName = null;
        if (extension.getCssResources() != null && !extension.getCssResources().isEmpty()) {
            resourceName = extension.getAppendRandomNumber() != false ? "datatables-" + extension.getName().toLowerCase() + "-" + table.getRandomId() + ".css" : "datatables-" + extension.getName().toLowerCase() + ".css";
            pluginsSourceCssFile = new CssResource(ResourceType.EXTENSION, resourceName);
            StringBuilder cssContent = new StringBuilder();
            for (CssResource cssResource : extension.getCssResources()) {
                if (cssResource.getType().equals((Object)ResourceType.EXTERNAL)) continue;
                cssContent.append(ResourceHelper.getFileContentFromClasspath(cssResource.getLocation()));
            }
            pluginsSourceCssFile.setContent(cssContent.toString());
            this.webResources.getStylesheets().put(pluginsSourceCssFile.getName(), pluginsSourceCssFile);
        }
    }

    private void injectIntoMainJsFile(Extension extension) throws IOException {
        if (extension.getBeforeAll() != null) {
            this.mainJsFile.appendToBeforeAll(extension.getBeforeAll().toString());
        }
        if (extension.getAfterStartDocumentReady() != null) {
            this.mainJsFile.appendToAfterStartDocumentReady(extension.getAfterStartDocumentReady().toString());
        }
        if (extension.getBeforeEndDocumentReady() != null) {
            this.mainJsFile.appendToBeforeEndDocumentReady(extension.getBeforeEndDocumentReady().toString());
        }
        if (extension.getAfterAll() != null) {
            this.mainJsFile.appendToAfterAll(extension.getAfterAll().toString());
        }
        if (extension.getFunction() != null) {
            this.mainJsFile.appendToDataTablesExtra(extension.getFunction());
        }
        if (extension.getConfigGenerator() != null) {
            logger.debug("A custom configuration generator has been set");
            JsonIndentingWriter writer = new JsonIndentingWriter();
            Map<String, Object> conf = extension.getConfigGenerator().generateConfig(this.table);
            JSONValue.writeJSONString(conf, (Writer)writer);
            this.mainJsFile.appendToDataTablesExtraConf(((Object)writer).toString());
        }
    }

    private void injectIntoMainConfiguration(Extension extension) {
        if (extension.getConfs() != null) {
            for (Configuration conf : extension.getConfs()) {
                if (this.mainConfig.containsKey(conf.getName())) {
                    if (this.mainConfig.get(conf.getName()) instanceof JavascriptFunction) {
                        this.processJavascriptFunction(conf);
                        continue;
                    }
                    if (this.mainConfig.get(conf.getName()) instanceof JavascriptSnippet) {
                        this.processJavascriptSnippet(conf);
                        continue;
                    }
                    this.processString(conf);
                    continue;
                }
                this.mainConfig.put(conf.getName(), conf.getValue());
            }
        }
    }

    private void processJavascriptFunction(Configuration conf) {
        JavascriptFunction jsFunction = (JavascriptFunction)this.mainConfig.get(conf.getName());
        String newValue = null;
        switch (conf.getMode()) {
            case OVERRIDE: {
                this.mainConfig.put(conf.getName(), conf.getValue());
                break;
            }
            case APPEND: {
                newValue = ((JavascriptFunction)conf.getValue()).getJavascript() + jsFunction.getJavascript();
                jsFunction.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsFunction);
                break;
            }
            case PREPEND: {
                newValue = jsFunction.getJavascript() + ((JavascriptFunction)conf.getValue()).getJavascript();
                jsFunction.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsFunction);
                break;
            }
            case APPEND_WITH_SPACE: {
                newValue = ((JavascriptFunction)conf.getValue()).getJavascript() + " " + jsFunction.getJavascript();
                jsFunction.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsFunction);
                break;
            }
            case PREPEND_WITH_SPACE: {
                newValue = jsFunction.getJavascript() + " " + ((JavascriptFunction)conf.getValue()).getJavascript();
                jsFunction.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsFunction);
                break;
            }
        }
    }

    private void processJavascriptSnippet(Configuration conf) {
        JavascriptSnippet jsSnippet = (JavascriptSnippet)this.mainConfig.get(conf.getName());
        String newValue = null;
        switch (conf.getMode()) {
            case OVERRIDE: {
                this.mainConfig.put(conf.getName(), conf.getValue());
                break;
            }
            case APPEND: {
                newValue = ((JavascriptSnippet)conf.getValue()).getJavascript() + jsSnippet.getJavascript();
                jsSnippet.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsSnippet);
                break;
            }
            case PREPEND: {
                newValue = jsSnippet.getJavascript() + ((JavascriptSnippet)conf.getValue()).getJavascript();
                jsSnippet.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsSnippet);
                break;
            }
            case APPEND_WITH_SPACE: {
                newValue = ((JavascriptSnippet)conf.getValue()).getJavascript() + " " + jsSnippet.getJavascript();
                jsSnippet.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsSnippet);
                break;
            }
            case PREPEND_WITH_SPACE: {
                newValue = jsSnippet.getJavascript() + " " + ((JavascriptSnippet)conf.getValue()).getJavascript();
                jsSnippet.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsSnippet);
                break;
            }
        }
    }

    private void processString(Configuration conf) {
        String value = null;
        switch (conf.getMode()) {
            case OVERRIDE: {
                this.mainConfig.put(conf.getName(), conf.getValue());
                break;
            }
            case APPEND: {
                value = (String)this.mainConfig.get(conf.getName());
                value = value + conf.getValue();
                this.mainConfig.put(conf.getName(), value);
                break;
            }
            case PREPEND: {
                value = (String)this.mainConfig.get(conf.getName());
                value = conf.getValue() + value;
                this.mainConfig.put(conf.getName(), value);
                break;
            }
            case APPEND_WITH_SPACE: {
                value = (String)this.mainConfig.get(conf.getName());
                value = value + " " + conf.getValue();
                this.mainConfig.put(conf.getName(), value);
                break;
            }
            case PREPEND_WITH_SPACE: {
                value = (String)this.mainConfig.get(conf.getName());
                value = conf.getValue() + " " + value;
                this.mainConfig.put(conf.getName(), value);
                break;
            }
        }
    }
}

