/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.generator;

import com.github.dandelion.datatables.core.asset.DisplayType;
import com.github.dandelion.datatables.core.generator.AbstractConfigurationGenerator;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFilteringGenerator
extends AbstractConfigurationGenerator {
    private static Logger logger = LoggerFactory.getLogger(ColumnFilteringGenerator.class);

    @Override
    public Map<String, Object> generateConfig(HtmlTable table) {
        logger.debug("Generating Column Filtering configuration ..");
        HashMap<String, Object> conf = new HashMap<String, Object>();
        HashMap<String, String> tmp = null;
        ArrayList aoColumnsContent = new ArrayList();
        for (HtmlColumn column : table.getLastHeaderRow().getColumns()) {
            if (!column.getEnabledDisplayTypes().contains((Object)DisplayType.ALL) && !column.getEnabledDisplayTypes().contains((Object)DisplayType.HTML)) continue;
            tmp = new HashMap<String, String>();
            if (column.isFilterable() != null && column.isFilterable().booleanValue() && column.getFilterType() != null) {
                switch (column.getFilterType()) {
                    case INPUT: {
                        tmp.put("type", "text");
                        break;
                    }
                    case NUMBER: {
                        tmp.put("type", "number");
                        break;
                    }
                    case SELECT: {
                        tmp.put("type", "select");
                        break;
                    }
                    default: {
                        tmp.put("type", "text");
                        break;
                    }
                }
            } else {
                tmp.put("type", "null");
            }
            aoColumnsContent.add(tmp);
        }
        conf.put("aoColumns", aoColumnsContent);
        logger.debug("Column filtering configuration generated");
        return conf;
    }
}

