/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.generator;

import com.github.dandelion.datatables.core.asset.DisplayType;
import com.github.dandelion.datatables.core.asset.JavascriptFunction;
import com.github.dandelion.datatables.core.asset.JavascriptSnippet;
import com.github.dandelion.datatables.core.callback.Callback;
import com.github.dandelion.datatables.core.generator.AbstractConfigurationGenerator;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainGenerator
extends AbstractConfigurationGenerator {
    private static Logger logger = LoggerFactory.getLogger(MainGenerator.class);

    @Override
    public Map<String, Object> generateConfig(HtmlTable table) {
        logger.debug("Generating DataTables configuration ..");
        HashMap<String, Object> mainConf = new HashMap<String, Object>();
        HashMap<String, Object> tmp = null;
        ArrayList aoColumnsContent = new ArrayList();
        for (HtmlColumn column : table.getLastHeaderRow().getColumns()) {
            if (!column.getEnabledDisplayTypes().contains((Object)DisplayType.ALL) && !column.getEnabledDisplayTypes().contains((Object)DisplayType.HTML)) continue;
            tmp = new HashMap<String, Object>();
            tmp.put("bSortable", column.isSortable());
            tmp.put("bSearchable", column.getSearchable());
            tmp.put("bVisible", column.getVisible());
            if (column.getVisible() != null && !column.getVisible().booleanValue()) {
                tmp.put("bSearchable", false);
            }
            if (StringUtils.isNotBlank((String)column.getProperty())) {
                tmp.put("mData", column.getProperty());
            }
            if (StringUtils.isNotBlank((String)column.getRenderFunction())) {
                tmp.put("mRender", new JavascriptSnippet(column.getRenderFunction()));
            }
            if (column.getDefaultValue() != null) {
                tmp.put("sDefaultContent", column.getDefaultValue());
            }
            if (column.getSortDirections() != null) {
                tmp.put("asSorting", column.getSortDirections());
            }
            aoColumnsContent.add(tmp);
        }
        mainConf.put("aoColumns", aoColumnsContent);
        ArrayList<Object> aaSortingtmp = null;
        ArrayList aaSortingContent = new ArrayList();
        Integer columnIndex = 0;
        for (HtmlColumn column : table.getLastHeaderRow().getColumns()) {
            if (StringUtils.isNotBlank((String)column.getSortInit())) {
                aaSortingtmp = new ArrayList<Object>();
                aaSortingtmp.add(columnIndex);
                aaSortingtmp.add(column.getSortInit());
                aaSortingContent.add(aaSortingtmp);
            }
            Integer n = columnIndex;
            Integer n2 = columnIndex = Integer.valueOf(columnIndex + 1);
        }
        if (!aaSortingContent.isEmpty()) {
            mainConf.put("aaSorting", aaSortingContent);
        }
        if (table.getLabels() != null) {
            tmp = new HashMap();
            tmp.put("sUrl", table.getLabels());
            mainConf.put("oLanguage", tmp);
        }
        if (table.getAutoWidth() != null) {
            mainConf.put("bAutoWidth", table.getAutoWidth());
        }
        if (table.getDeferRender() != null) {
            mainConf.put("bDeferRender", table.getDeferRender());
        }
        if (table.getFilterable() != null) {
            mainConf.put("bFilter", table.getFilterable());
        }
        if (table.getInfo() != null) {
            mainConf.put("bInfo", table.getInfo());
        }
        if (table.getPaginate() != null) {
            mainConf.put("bPaginate", table.getPaginate());
        }
        if (table.getDisplayLength() != null) {
            mainConf.put("iDisplayLength", table.getDisplayLength());
        }
        if (table.getLengthChange() != null) {
            mainConf.put("bLengthChange", table.getLengthChange());
        }
        if (table.getPaginationType() != null) {
            mainConf.put("sPaginationType", table.getPaginationType().toString());
        }
        if (table.getSort() != null) {
            mainConf.put("bSort", table.getSort());
        }
        if (table.getStateSave() != null) {
            mainConf.put("bStateSave", table.getStateSave());
        }
        if (table.getJqueryUI() != null) {
            mainConf.put("bJQueryUI", table.getJqueryUI());
        }
        if (StringUtils.isNotBlank((String)table.getLengthMenu())) {
            mainConf.put("aLengthMenu", new JavascriptSnippet(table.getLengthMenu()));
        }
        if (StringUtils.isNotBlank((String)table.getStripeClasses())) {
            mainConf.put("asStripeClasses", new JavascriptSnippet(table.getStripeClasses()));
        }
        if (StringUtils.isNotBlank((String)table.getScrollY())) {
            mainConf.put("sScrollY", table.getScrollY());
        }
        if (table.getScrollCollapse() != null) {
            mainConf.put("bScrollCollapse", table.getScrollCollapse());
        }
        if (table.getProcessing() != null) {
            mainConf.put("bProcessing", table.getProcessing());
        }
        if (table.getServerSide() != null) {
            mainConf.put("bServerSide", table.getServerSide());
            if (StringUtils.isNotBlank((String)table.getDatasourceUrl())) {
                mainConf.put("sAjaxSource", table.getDatasourceUrl());
            }
            if (StringUtils.isNotBlank((String)table.getServerData())) {
                mainConf.put("fnServerData", new JavascriptSnippet(table.getServerData()));
            }
            if (StringUtils.isNotBlank((String)table.getServerParam())) {
                mainConf.put("fnServerParams", new JavascriptSnippet(table.getServerParam()));
            }
            if (StringUtils.isNotBlank((String)table.getServerMethod())) {
                mainConf.put("sServerMethod", table.getServerMethod());
            }
        }
        if (table.getCallbacks() != null) {
            for (Callback callback : table.getCallbacks()) {
                mainConf.put(callback.getType().getName(), new JavascriptFunction(callback.getFunction(), callback.getType().getArgs()));
            }
        }
        mainConf.put("sDom", "lfrtip");
        logger.debug("DataTables configuration generated");
        return mainConf;
    }
}

