/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.generator;

import com.github.dandelion.datatables.core.asset.ExtraConf;
import com.github.dandelion.datatables.core.asset.ExtraFile;
import com.github.dandelion.datatables.core.asset.JsResource;
import com.github.dandelion.datatables.core.asset.ResourceType;
import com.github.dandelion.datatables.core.asset.WebResources;
import com.github.dandelion.datatables.core.callback.Callback;
import com.github.dandelion.datatables.core.callback.CallbackType;
import com.github.dandelion.datatables.core.exception.BadConfigurationException;
import com.github.dandelion.datatables.core.exception.CompressionException;
import com.github.dandelion.datatables.core.exception.DataNotFoundException;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.export.ExportLinkPosition;
import com.github.dandelion.datatables.core.extension.ExtensionLoader;
import com.github.dandelion.datatables.core.generator.MainGenerator;
import com.github.dandelion.datatables.core.html.HtmlDiv;
import com.github.dandelion.datatables.core.html.HtmlHyperlink;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.util.JsonIndentingWriter;
import com.github.dandelion.datatables.core.util.ResourceHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResourceGenerator {
    private static Logger logger = LoggerFactory.getLogger(WebResourceGenerator.class);
    private Writer writer = new JsonIndentingWriter();
    private static MainGenerator configGenerator;

    public WebResources generateWebResources(HtmlTable table) throws DataNotFoundException, CompressionException, IOException, BadConfigurationException {
        WebResources webResources = new WebResources();
        if (table.isExportable().booleanValue()) {
            this.exportManagement(table);
        }
        configGenerator = new MainGenerator();
        Map<String, Object> mainConf = configGenerator.generateConfig(table);
        String tableId = table.getRandomId();
        JsResource mainJsFile = new JsResource(ResourceType.MAIN, "datatables-" + tableId + ".js");
        mainJsFile.setTableId(table.getId());
        if (table.getExtraFiles() != null && !table.getExtraFiles().isEmpty()) {
            this.extraFileManagement(mainJsFile, table);
        }
        ExtensionLoader extensionLoader = new ExtensionLoader(table, mainJsFile, mainConf, webResources);
        extensionLoader.load(table.getPlugins());
        extensionLoader.load(table.getFeatures());
        if (table.getTheme() != null) {
            extensionLoader.load(Arrays.asList(table.getTheme()));
        }
        if (table.getExtraConfs() != null) {
            this.extraConfManagement(mainJsFile, mainConf, table);
        }
        JSONValue.writeJSONString(mainConf, (Writer)this.writer);
        mainJsFile.appendToDataTablesConf(this.writer.toString());
        if (StringUtils.isNotBlank((String)table.getAppear())) {
            if ("block".equals(table.getAppear())) {
                mainJsFile.appendToBeforeEndDocumentReady("$('#" + table.getId() + "').show();");
            } else if (StringUtils.isNotBlank((String)table.getAppearDuration())) {
                mainJsFile.appendToBeforeEndDocumentReady("$('#" + table.getId() + "').fadeIn(" + table.getAppearDuration() + ");");
            } else {
                mainJsFile.appendToBeforeEndDocumentReady("$('#" + table.getId() + "').fadeIn();");
            }
        }
        webResources.setMainJsFile(mainJsFile);
        return webResources;
    }

    private void exportManagement(HtmlTable table) {
        StringBuilder links = new StringBuilder();
        for (ExportLinkPosition position : table.getExportLinkPositions()) {
            HtmlDiv divExport = this.initExportDiv(table);
            switch (position) {
                case BOTTOM_LEFT: {
                    divExport.addCssStyle("float:left;margin-right:10px;");
                    links.append("$('#" + table.getId() + "_info').before('" + divExport.toHtml() + "');$('#" + table.getId() + "_info').css('clear', 'none');");
                    break;
                }
                case BOTTOM_MIDDLE: {
                    divExport.addCssStyle("float:left;margin-left:10px;");
                    links.append("$('#" + table.getId() + "_paginate').before('" + divExport.toHtml() + "');");
                    break;
                }
                case BOTTOM_RIGHT: {
                    divExport.addCssStyle("float:right;");
                    links.append("$('#" + table.getId() + "_paginate').before('" + divExport.toHtml() + "');");
                    break;
                }
                case TOP_LEFT: {
                    divExport.addCssStyle("float:left;margin-right:10px;");
                    links.append("$('#" + table.getId() + "_length').before('" + divExport.toHtml() + "');");
                    break;
                }
                case TOP_MIDDLE: {
                    divExport.addCssStyle("float:left;margin-left:10px;");
                    links.append("$('#" + table.getId() + "_filter').before('" + divExport.toHtml() + "');");
                    break;
                }
                case TOP_RIGHT: {
                    divExport.addCssStyle("float:right;");
                    links.append("$('#" + table.getId() + "_filter').before('" + divExport.toHtml() + "');");
                    break;
                }
            }
        }
        if (table.hasCallback(CallbackType.INIT).booleanValue()) {
            table.getCallback(CallbackType.INIT).addContent(links.toString());
        } else {
            Callback initCallback = new Callback(CallbackType.INIT, links.toString());
            table.registerCallback(initCallback);
        }
    }

    private HtmlDiv initExportDiv(HtmlTable table) {
        HtmlDiv divExport = new HtmlDiv();
        divExport.addCssClass("dandelion_dataTables_export");
        if (table.getExportConfMap() != null && table.getExportConfMap().size() > 0) {
            logger.debug("Generating export links");
            HtmlHyperlink link = null;
            for (ExportConf conf : table.getExportConfMap().values()) {
                link = new HtmlHyperlink();
                if (conf.getCssClass() != null) {
                    link.setCssClass(conf.getCssClass());
                }
                if (conf.getCssStyle() != null) {
                    link.setCssStyle(conf.getCssStyle());
                    link.addCssStyle(";margin-left:2px;");
                } else {
                    link.addCssStyle("margin-left:2px;");
                }
                link.setHref(conf.getUrl());
                link.addContent(conf.getLabel());
                divExport.addContent(link.toHtml());
            }
        }
        return divExport;
    }

    private void extraFileManagement(JsResource mainFile, HtmlTable table) throws IOException, BadConfigurationException {
        logger.info("Extra files found");
        block6: for (ExtraFile file : table.getExtraFiles()) {
            switch (file.getInsert()) {
                case BEFOREALL: {
                    mainFile.appendToBeforeAll(ResourceHelper.getFileContentFromWebapp(file.getSrc()));
                    continue block6;
                }
                case AFTERSTARTDOCUMENTREADY: {
                    mainFile.appendToAfterStartDocumentReady(ResourceHelper.getFileContentFromWebapp(file.getSrc()));
                    continue block6;
                }
                case BEFOREENDDOCUMENTREADY: {
                    mainFile.appendToBeforeEndDocumentReady(ResourceHelper.getFileContentFromWebapp(file.getSrc()));
                    continue block6;
                }
                case AFTERALL: {
                    mainFile.appendToAfterAll(ResourceHelper.getFileContentFromWebapp(file.getSrc()));
                    continue block6;
                }
            }
            throw new BadConfigurationException("Unable to get the extraFile " + file.getSrc());
        }
    }

    private void extraConfManagement(JsResource mainJsFile, Map<String, Object> mainConf, HtmlTable table) throws BadConfigurationException {
        for (ExtraConf conf : table.getExtraConfs()) {
            StringBuilder extaConf = new StringBuilder();
            extaConf.append("$.ajax({url:\"");
            extaConf.append(conf.getSrc());
            extaConf.append("\",dataType: \"text\",type: \"GET\", async: false, success: function(extraProperties, xhr, response) {");
            extaConf.append("$.extend(true, oTable_");
            extaConf.append(table.getId());
            extaConf.append("_params, eval('(' + extraProperties + ')'));");
            extaConf.append("}, error : function(jqXHR, textStatus, errorThrown){");
            extaConf.append("console.log(textStatus);");
            extaConf.append("console.log(errorThrown);");
            extaConf.append("}});");
            extaConf.append("console.log(oTable_" + table.getId() + "_params);");
            mainJsFile.appendToBeforeStartDocumentReady(extaConf.toString());
        }
    }
}

