/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.html;

import com.github.dandelion.datatables.core.asset.DisplayType;
import com.github.dandelion.datatables.core.feature.FilterType;
import com.github.dandelion.datatables.core.html.HtmlTagWithContent;
import java.util.ArrayList;
import java.util.List;

public class HtmlColumn
extends HtmlTagWithContent {
    private String uid;
    private Boolean isHeaderColumn;
    private StringBuilder cssCellClass;
    private StringBuilder cssCellStyle;
    private Boolean sortable;
    private List<String> sortDirections;
    private String sortInit;
    private String property;
    private String defaultValue;
    private Boolean filterable;
    private Boolean searchable;
    private String renderFunction;
    private Boolean visible;
    private FilterType filterType;
    private String filterCssClass;
    private String filterPlaceholder;
    private List<DisplayType> enabledDisplayTypes = new ArrayList<DisplayType>();

    public HtmlColumn() {
        this.init();
        this.setHeaderColumn(false);
    }

    public HtmlColumn(DisplayType displayType) {
        this.init();
        this.enabledDisplayTypes.clear();
        this.enabledDisplayTypes.add(displayType);
        this.setHeaderColumn(false);
    }

    public HtmlColumn(Boolean isHeader) {
        this.init();
        this.setHeaderColumn(isHeader);
    }

    public HtmlColumn(Boolean isHeader, String content) {
        this.init();
        this.setHeaderColumn(isHeader);
        if (content != null) {
            this.setContent(new StringBuilder(content));
        }
    }

    private void init() {
        this.sortable = true;
        this.filterable = false;
        this.searchable = true;
        this.visible = true;
        this.filterType = FilterType.INPUT;
        this.enabledDisplayTypes.add(DisplayType.ALL);
    }

    @Override
    protected StringBuilder getHtmlAttributes() {
        StringBuilder html = new StringBuilder();
        html.append((CharSequence)HtmlColumn.writeAttribute("id", this.id));
        if (this.isHeaderColumn.booleanValue()) {
            html.append((CharSequence)HtmlColumn.writeAttribute("class", this.cssClass));
            html.append((CharSequence)HtmlColumn.writeAttribute("style", this.cssStyle));
        } else {
            html.append((CharSequence)HtmlColumn.writeAttribute("class", this.cssCellClass));
            html.append((CharSequence)HtmlColumn.writeAttribute("style", this.cssCellStyle));
        }
        return html;
    }

    private void setHeaderColumn(Boolean isHeaderColumn) {
        this.isHeaderColumn = isHeaderColumn;
        this.tag = this.isHeaderColumn != false ? "th" : "td";
    }

    public Boolean isHeaderColumn() {
        return this.isHeaderColumn;
    }

    public StringBuilder getCssCellClass() {
        return this.cssClass;
    }

    public void setCssCellClass(StringBuilder cssCellClass) {
        this.cssCellClass = cssCellClass;
    }

    public StringBuilder getCssCellStyle() {
        return this.cssCellStyle;
    }

    public void setCssCellStyle(StringBuilder cssCellStyle) {
        this.cssCellStyle = cssCellStyle;
    }

    public void addCssCellClass(String cssCellClass) {
        if (this.cssCellClass == null) {
            this.cssCellClass = new StringBuilder();
        } else {
            this.cssCellClass.append(' ');
        }
        this.cssCellClass.append(cssCellClass);
    }

    public void addCssCellStyle(String cssCellStyle) {
        if (this.cssCellStyle == null) {
            this.cssCellStyle = new StringBuilder();
        } else {
            this.cssCellStyle.append(';');
        }
        this.cssCellStyle.append(cssCellStyle);
    }

    public Boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(Boolean sortable) {
        this.sortable = sortable;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Boolean isFilterable() {
        return this.filterable;
    }

    public void setFilterable(Boolean filterable) {
        this.filterable = filterable;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public void setFilterType(FilterType filterType) {
        this.filterType = filterType;
    }

    public String getFilterCssClass() {
        return this.filterCssClass;
    }

    public void setFilterCssClass(String filterCssClass) {
        this.filterCssClass = filterCssClass;
    }

    public String getFilterPlaceholder() {
        return this.filterPlaceholder;
    }

    public void setFilterPlaceholder(String filterPlaceholder) {
        this.filterPlaceholder = filterPlaceholder;
    }

    public List<String> getSortDirections() {
        return this.sortDirections;
    }

    public void setSortDirections(List<String> sortDirections) {
        this.sortDirections = sortDirections;
    }

    public String getSortInit() {
        return this.sortInit;
    }

    public void setSortInit(String sortInit) {
        this.sortInit = sortInit;
    }

    public List<DisplayType> getEnabledDisplayTypes() {
        return this.enabledDisplayTypes;
    }

    public void setEnabledDisplayTypes(List<DisplayType> enabledDisplayTypes) {
        this.enabledDisplayTypes = enabledDisplayTypes;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String toString() {
        return "HtmlColumn [uid=" + this.uid + ", isHeaderColumn=" + this.isHeaderColumn + ", cssCellClass=" + this.cssCellClass + ", cssCellStyle=" + this.cssCellStyle + ", content=" + this.content + ", sortable=" + this.sortable + ", sortDirections=" + this.sortDirections + ", sortInit=" + this.sortInit + ", property=" + this.property + ", defaultValue=" + this.defaultValue + ", filterable=" + this.filterable + ", filterType=" + (Object)((Object)this.filterType) + ", filterCssClass=" + this.filterCssClass + ", filterPlaceholder=" + this.filterPlaceholder + ", enabledDisplayTypes=" + this.enabledDisplayTypes + ", rendererFunction=" + this.renderFunction + "]";
    }

    public Boolean getSearchable() {
        return this.searchable;
    }

    public void setSearchable(Boolean searchable) {
        this.searchable = searchable;
    }

    public String getRenderFunction() {
        return this.renderFunction;
    }

    public void setRenderFunction(String rendererFunction) {
        this.renderFunction = rendererFunction;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }
}

