/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.html;

import com.github.dandelion.datatables.core.asset.DisplayType;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class HtmlRow
extends HtmlTag {
    private List<HtmlColumn> columns = new LinkedList<HtmlColumn>();

    public HtmlRow() {
        this.tag = "tr";
    }

    public HtmlRow(String id) {
        this.tag = "tr";
        this.id = id;
    }

    @Override
    public StringBuilder toHtml() {
        StringBuilder html = new StringBuilder();
        html.append((CharSequence)this.getHtmlOpeningTag());
        html.append((CharSequence)this.getHtmlColumns());
        html.append((CharSequence)this.getHtmlClosingTag());
        return html;
    }

    private StringBuilder getHtmlColumns() {
        StringBuilder html = new StringBuilder();
        for (HtmlColumn column : this.columns) {
            if (!column.getEnabledDisplayTypes().contains((Object)DisplayType.ALL) && !column.getEnabledDisplayTypes().contains((Object)DisplayType.HTML)) continue;
            html.append((CharSequence)column.toHtml());
        }
        return html;
    }

    public List<HtmlColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<HtmlColumn> columns) {
        this.columns = columns;
    }

    public HtmlColumn addHeaderColumn(HtmlColumn headerColumn) {
        this.columns.add(headerColumn);
        return headerColumn;
    }

    public HtmlColumn addHeaderColumn(String columnContent) {
        HtmlColumn newColumn = new HtmlColumn(true, columnContent);
        this.columns.add(newColumn);
        return newColumn;
    }

    public HtmlColumn addColumn(HtmlColumn column) {
        this.columns.add(column);
        return column;
    }

    public HtmlColumn addColumn(String columnContent) {
        HtmlColumn newColumn = new HtmlColumn(false, columnContent);
        this.columns.add(newColumn);
        return newColumn;
    }

    public HtmlColumn addColumn(String columnContent, DisplayType ... displayTypes) {
        HtmlColumn newColumn = new HtmlColumn(false, columnContent);
        newColumn.setEnabledDisplayTypes(Arrays.asList(displayTypes));
        this.columns.add(newColumn);
        return newColumn;
    }

    public HtmlRow addHeaderColumns(String ... columns) {
        for (String columnContent : columns) {
            this.addHeaderColumn(columnContent);
        }
        return this;
    }

    public List<HtmlColumn> getHeaderColumns() {
        ArrayList<HtmlColumn> retval = new ArrayList<HtmlColumn>();
        for (HtmlColumn column : this.columns) {
            if (!column.isHeaderColumn().booleanValue()) continue;
            retval.add(column);
        }
        return retval;
    }

    public HtmlRow addColumns(String ... columns) {
        for (String columnContent : columns) {
            this.addColumn(columnContent);
        }
        return this;
    }

    public HtmlColumn getLastColumn() {
        return (HtmlColumn)((LinkedList)this.columns).getLast();
    }

    public String toString() {
        return "HtmlRow [columns=" + this.columns + "]";
    }
}

