/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.html;

import com.github.dandelion.datatables.core.asset.ExtraConf;
import com.github.dandelion.datatables.core.asset.ExtraFile;
import com.github.dandelion.datatables.core.callback.Callback;
import com.github.dandelion.datatables.core.callback.CallbackType;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.export.ExportLinkPosition;
import com.github.dandelion.datatables.core.export.ExportProperties;
import com.github.dandelion.datatables.core.export.ExportType;
import com.github.dandelion.datatables.core.feature.AbstractFeature;
import com.github.dandelion.datatables.core.feature.PaginationType;
import com.github.dandelion.datatables.core.html.HtmlCaption;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlRow;
import com.github.dandelion.datatables.core.html.HtmlTag;
import com.github.dandelion.datatables.core.plugin.AbstractPlugin;
import com.github.dandelion.datatables.core.properties.TableProperties;
import com.github.dandelion.datatables.core.theme.AbstractTheme;
import com.github.dandelion.datatables.core.theme.ThemeOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HtmlTable
extends HtmlTag {
    private Boolean autoWidth;
    private Boolean deferRender;
    private Boolean info;
    private Boolean filterable;
    private Boolean paginate;
    private PaginationType paginationType;
    private Boolean lengthChange;
    private Boolean sort;
    private Boolean stateSave;
    private String labels;
    private Boolean cdn;
    private Boolean jqueryUI;
    private String appear;
    private String appearDuration;
    private String lengthMenu;
    private String stripeClasses;
    private Integer displayLength;
    private Boolean processing;
    private Boolean serverSide;
    private String ajaxSource;
    private Boolean pipelining;
    private int pipeSize;
    private Boolean jsonp;
    private String serverData;
    private String serverParam;
    private String serverMethod;
    private String scrollY;
    private Boolean scrollCollapse;
    private String fixedPosition;
    private Integer fixedOffsetTop;
    private List<Callback> callbacks;
    private HtmlCaption caption;
    private List<HtmlRow> head = new LinkedList<HtmlRow>();
    private List<HtmlRow> body = new LinkedList<HtmlRow>();
    private List<HtmlRow> foot = new LinkedList<HtmlRow>();
    private TableProperties tableProperties = new TableProperties();
    private String datasourceUrl;
    private List<AbstractPlugin> plugins;
    private List<AbstractFeature> features;
    private List<ExtraFile> extraFiles;
    private List<ExtraConf> extraConfs;
    private String randomId;
    private String objectType;
    private String currentUrl;
    private ExportProperties exportProperties;
    private Boolean exporting;
    private Map<ExportType, ExportConf> exportConfMap = new HashMap<ExportType, ExportConf>();
    private List<ExportLinkPosition> exportLinkPositions;
    private Boolean isExportable = false;
    private AbstractTheme theme;
    private ThemeOption themeOption;

    public HtmlTable(String id, String randomId) {
        this.tag = "table";
        this.init();
        this.id = id;
        this.randomId = randomId;
    }

    private void init() {
        this.cdn = false;
        this.isExportable = false;
        ArrayList<ExportLinkPosition> exportLinkPositions = new ArrayList<ExportLinkPosition>();
        exportLinkPositions.add(ExportLinkPosition.TOP_RIGHT);
        this.exportLinkPositions = exportLinkPositions;
        this.pipeSize = 5;
    }

    @Override
    public StringBuilder toHtml() {
        StringBuilder html = new StringBuilder();
        html.append((CharSequence)this.getHtmlOpeningTag());
        html.append((CharSequence)this.getHtmlHeader());
        html.append((CharSequence)this.getHtmlBody());
        html.append((CharSequence)this.getHtmlFooter());
        html.append((CharSequence)this.getHtmlClosingTag());
        return html;
    }

    private StringBuilder getHtmlHeader() {
        StringBuilder html = new StringBuilder();
        if (this.caption != null) {
            html.append((CharSequence)this.caption.toHtml());
        }
        html.append("<thead>");
        for (HtmlRow row : this.head) {
            html.append((CharSequence)row.toHtml());
        }
        html.append("</thead>");
        return html;
    }

    private StringBuilder getHtmlBody() {
        StringBuilder html = new StringBuilder();
        html.append("<tbody>");
        for (HtmlRow row : this.body) {
            html.append((CharSequence)row.toHtml());
        }
        html.append("</tbody>");
        return html;
    }

    private StringBuilder getHtmlFooter() {
        StringBuilder html = new StringBuilder();
        if (!this.foot.isEmpty()) {
            html.append("<tfoot>");
            for (HtmlRow row : this.foot) {
                html.append((CharSequence)row.toHtml());
            }
            html.append("</tfoot>");
        }
        return html;
    }

    @Override
    protected StringBuilder getHtmlAttributes() {
        if (this.appear != null && !"".equals(this.appear)) {
            this.addCssStyle("display:none");
        }
        StringBuilder html = new StringBuilder();
        html.append((CharSequence)HtmlTable.writeAttribute("id", this.id));
        html.append((CharSequence)HtmlTable.writeAttribute("class", this.cssClass));
        html.append((CharSequence)HtmlTable.writeAttribute("style", this.cssStyle));
        return html;
    }

    public HtmlCaption getCaption() {
        return this.caption;
    }

    public void setCaption(HtmlCaption caption) {
        this.caption = caption;
    }

    public List<HtmlRow> getHeadRows() {
        return this.head;
    }

    public List<HtmlRow> getBodyRows() {
        return this.body;
    }

    public HtmlRow addHeaderRow() {
        HtmlRow row = new HtmlRow();
        this.head.add(row);
        return row;
    }

    public HtmlRow addRow() {
        HtmlRow row = new HtmlRow();
        this.body.add(row);
        return row;
    }

    public HtmlRow addFooterRow() {
        HtmlRow row = new HtmlRow();
        this.foot.add(row);
        return row;
    }

    public HtmlRow addRow(String rowId) {
        HtmlRow row = new HtmlRow(rowId);
        this.body.add(row);
        return row;
    }

    public HtmlTable addRows(HtmlRow ... rows) {
        for (HtmlRow row : rows) {
            this.body.add(row);
        }
        return this;
    }

    public HtmlRow getLastFooterRow() {
        return (HtmlRow)((LinkedList)this.foot).getLast();
    }

    public HtmlRow getLastHeaderRow() {
        return (HtmlRow)((LinkedList)this.head).getLast();
    }

    public HtmlRow getLastBodyRow() {
        return (HtmlRow)((LinkedList)this.body).getLast();
    }

    public void registerPlugin(AbstractPlugin plugin) {
        if (this.plugins == null) {
            this.plugins = new ArrayList<AbstractPlugin>();
        }
        this.plugins.add(plugin);
    }

    public void registerFeature(AbstractFeature feature) {
        if (this.features == null) {
            this.features = new ArrayList<AbstractFeature>();
        }
        this.features.add(feature);
    }

    public Boolean hasOneFilterableColumn() {
        Boolean retval = false;
        block0: for (HtmlRow headerRow : this.head) {
            for (HtmlColumn headerColumn : headerRow.getHeaderColumns()) {
                if (headerColumn.isFilterable() == null || !headerColumn.isFilterable().booleanValue()) continue;
                retval = true;
                continue block0;
            }
        }
        return retval;
    }

    public HtmlColumn getColumnHeadByUid(String uid) {
        for (HtmlRow row : this.head) {
            for (HtmlColumn column : row.getColumns()) {
                if (column.isHeaderColumn() == null || !column.isHeaderColumn().booleanValue() || column.getUid() == null || !column.getUid().equals(uid)) continue;
                return column;
            }
        }
        return null;
    }

    public Boolean getAutoWidth() {
        return this.autoWidth;
    }

    public void setAutoWidth(Boolean autoWidth) {
        this.autoWidth = autoWidth;
    }

    public Boolean getDeferRender() {
        return this.deferRender;
    }

    public void setDeferRender(Boolean deferRender) {
        this.deferRender = deferRender;
    }

    public Boolean getInfo() {
        return this.info;
    }

    public void setInfo(Boolean info) {
        this.info = info;
    }

    public Boolean getFilterable() {
        return this.filterable;
    }

    public void setFilterable(Boolean filterable) {
        this.filterable = filterable;
    }

    public Boolean getPaginate() {
        return this.paginate;
    }

    public void setPaginate(Boolean paginate) {
        this.paginate = paginate;
    }

    public PaginationType getPaginationType() {
        return this.paginationType;
    }

    public void setPaginationType(PaginationType paginationStyle) {
        this.paginationType = paginationStyle;
    }

    public Boolean getLengthChange() {
        return this.lengthChange;
    }

    public void setLengthChange(Boolean lengthChange) {
        this.lengthChange = lengthChange;
    }

    public Boolean getProcessing() {
        return this.processing;
    }

    public void setProcessing(Boolean processing) {
        this.processing = processing;
    }

    public Boolean getServerSide() {
        return this.serverSide;
    }

    public void setServerSide(Boolean serverSide) {
        this.serverSide = serverSide;
    }

    public String getAjaxSource() {
        return this.ajaxSource;
    }

    public void setAjaxSource(String ajaxSource) {
        this.ajaxSource = ajaxSource;
    }

    public Boolean getSort() {
        return this.sort;
    }

    public void setSort(Boolean sort) {
        this.sort = sort;
    }

    public Boolean getStateSave() {
        return this.stateSave;
    }

    public void setStateSave(Boolean stateSave) {
        this.stateSave = stateSave;
    }

    public String getDatasourceUrl() {
        return this.datasourceUrl;
    }

    public void setDatasourceUrl(String datasourceUrl) {
        this.datasourceUrl = datasourceUrl;
    }

    public String getScrollY() {
        return this.scrollY;
    }

    public void setScrollY(String scrollY) {
        this.scrollY = scrollY;
    }

    public Boolean getScrollCollapse() {
        return this.scrollCollapse;
    }

    public void setScrollCollapse(Boolean scrollCollapse) {
        this.scrollCollapse = scrollCollapse;
    }

    public List<ExtraFile> getExtraFiles() {
        return this.extraFiles;
    }

    public void addExtraFile(ExtraFile extraFile) {
        if (this.extraFiles == null) {
            this.extraFiles = new ArrayList<ExtraFile>();
        }
        this.extraFiles.add(extraFile);
    }

    public List<ExtraConf> getExtraConfs() {
        return this.extraConfs;
    }

    public void addExtraConf(ExtraConf extraConf) {
        if (this.extraConfs == null) {
            this.extraConfs = new ArrayList<ExtraConf>();
        }
        this.extraConfs.add(extraConf);
    }

    public List<AbstractPlugin> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<AbstractPlugin> plugins) {
        this.plugins = plugins;
    }

    public List<AbstractFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<AbstractFeature> features) {
        this.features = features;
    }

    public String getFixedPosition() {
        return this.fixedPosition;
    }

    public void setFixedPosition(String fixedPosition) {
        this.fixedPosition = fixedPosition;
    }

    public Boolean getCdn() {
        return this.cdn;
    }

    public void setCdn(Boolean cdn) {
        this.cdn = cdn;
    }

    public Integer getFixedOffsetTop() {
        return this.fixedOffsetTop;
    }

    public void setFixedOffsetTop(Integer fixedOffsetTop) {
        this.fixedOffsetTop = fixedOffsetTop;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getRandomId() {
        return this.randomId;
    }

    public void setRandomId(String randomId) {
        this.randomId = randomId;
    }

    public Boolean getJqueryUI() {
        return this.jqueryUI;
    }

    public void setJqueryUI(Boolean jqueryUI) {
        this.jqueryUI = jqueryUI;
    }

    public TableProperties getTableProperties() {
        return this.tableProperties;
    }

    public void setTableProperties(TableProperties tableProperties) {
        this.tableProperties = tableProperties;
    }

    public Boolean getExporting() {
        return this.exporting;
    }

    public void setExporting(Boolean exporting) {
        this.exporting = exporting;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public ExportProperties getExportProperties() {
        return this.exportProperties;
    }

    public void setExportProperties(ExportProperties exportProperties) {
        this.exportProperties = exportProperties;
    }

    public Map<ExportType, ExportConf> getExportConfMap() {
        return this.exportConfMap;
    }

    public void configureExport(ExportType exportType, ExportConf exportConf) {
        this.exportConfMap.put(exportType, exportConf);
    }

    public void setExportConfMap(Map<ExportType, ExportConf> exportConfs) {
        this.exportConfMap = exportConfs;
    }

    public Boolean isExportable() {
        return this.isExportable;
    }

    public void setIsExportable(Boolean isExportable) {
        this.isExportable = isExportable;
    }

    public List<ExportLinkPosition> getExportLinkPositions() {
        return this.exportLinkPositions;
    }

    public void setExportLinkPositions(List<ExportLinkPosition> exportLinkPositions) {
        this.exportLinkPositions = exportLinkPositions;
    }

    public String getCurrentUrl() {
        return this.currentUrl;
    }

    public void setCurrentUrl(String currentUrl) {
        this.currentUrl = currentUrl;
    }

    public AbstractTheme getTheme() {
        return this.theme;
    }

    public void setTheme(AbstractTheme theme) {
        this.theme = theme;
    }

    public ThemeOption getThemeOption() {
        return this.themeOption;
    }

    public void setThemeOption(ThemeOption themeOption) {
        this.themeOption = themeOption;
    }

    public String getAppear() {
        return this.appear;
    }

    public void setAppear(String appear) {
        this.appear = appear;
    }

    public String getAppearDuration() {
        return this.appearDuration;
    }

    public void setAppearDuration(String appearDuration) {
        this.appearDuration = appearDuration;
    }

    public Boolean getPipelining() {
        return this.pipelining;
    }

    public void setPipelining(Boolean pipelining) {
        this.pipelining = pipelining;
    }

    public int getPipeSize() {
        return this.pipeSize;
    }

    public void setPipeSize(int pipeSize) {
        this.pipeSize = pipeSize;
    }

    public Boolean getJsonp() {
        return this.jsonp;
    }

    public void setJsonp(Boolean jsonp) {
        this.jsonp = jsonp;
    }

    public List<Callback> getCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(List<Callback> callbacks) {
        this.callbacks = callbacks;
    }

    public void registerCallback(Callback callback) {
        if (this.callbacks == null) {
            this.callbacks = new ArrayList<Callback>();
        }
        this.callbacks.add(callback);
    }

    public Boolean hasCallback(CallbackType callbackType) {
        if (this.callbacks != null) {
            for (Callback callback : this.callbacks) {
                if (!callback.getType().equals((Object)callbackType)) continue;
                return true;
            }
        }
        return false;
    }

    public Callback getCallback(CallbackType callbackType) {
        for (Callback callback : this.callbacks) {
            if (!callback.getType().equals((Object)callbackType)) continue;
            return callback;
        }
        return null;
    }

    public String getLengthMenu() {
        return this.lengthMenu;
    }

    public void setLengthMenu(String lengthMenu) {
        this.lengthMenu = lengthMenu;
    }

    public String getStripeClasses() {
        return this.stripeClasses;
    }

    public void setStripeClasses(String stripeClasses) {
        this.stripeClasses = stripeClasses;
    }

    public String getServerData() {
        return this.serverData;
    }

    public void setServerData(String serverData) {
        this.serverData = serverData;
    }

    public String getServerParam() {
        return this.serverParam;
    }

    public void setServerParam(String serverParam) {
        this.serverParam = serverParam;
    }

    public String getServerMethod() {
        return this.serverMethod;
    }

    public void setServerMethod(String serverMethod) {
        this.serverMethod = serverMethod;
    }

    public Integer getDisplayLength() {
        return this.displayLength;
    }

    public void setDisplayLength(Integer displayLength) {
        this.displayLength = displayLength;
    }

    public String toString() {
        return "HtmlTable [autoWidth=" + this.autoWidth + ", deferRender=" + this.deferRender + ", info=" + this.info + ", filterable=" + this.filterable + ", paginate=" + this.paginate + ", paginationType=" + (Object)((Object)this.paginationType) + ", lengthChange=" + this.lengthChange + ", sort=" + this.sort + ", stateSave=" + this.stateSave + ", labels=" + this.labels + ", cdn=" + this.cdn + ", jqueryUI=" + this.jqueryUI + ", appear=" + this.appear + ", appearDuration=" + this.appearDuration + ", lengthMenu=" + this.lengthMenu + ", stripeClasses=" + this.stripeClasses + ", processing=" + this.processing + ", serverSide=" + this.serverSide + ", ajaxSource=" + this.ajaxSource + ", pipelining=" + this.pipelining + ", pipeSize=" + this.pipeSize + ", jsonp=" + this.jsonp + ", serverData=" + this.serverData + ", serverParam=" + this.serverParam + ", serverMethod=" + this.serverMethod + ", scrollY=" + this.scrollY + ", fixedPosition=" + this.fixedPosition + ", fixedOffsetTop=" + this.fixedOffsetTop + ", callbacks=" + this.callbacks + ", head=" + this.head + ", body=" + this.body + ", foot=" + this.foot + ", tableProperties=" + this.tableProperties + ", datasourceUrl=" + this.datasourceUrl + ", plugins=" + this.plugins + ", features=" + this.features + ", extraFiles=" + this.extraFiles + ", extraConfs=" + this.extraConfs + ", randomId=" + this.randomId + ", objectType=" + this.objectType + ", currentUrl=" + this.currentUrl + ", exportProperties=" + this.exportProperties + ", exporting=" + this.exporting + ", exportConfMap=" + this.exportConfMap + ", exportLinkPositions=" + this.exportLinkPositions + ", isExportable=" + this.isExportable + ", theme=" + this.theme + ", themeOption=" + (Object)((Object)this.themeOption) + "]";
    }
}

