/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.html;

public abstract class HtmlTag {
    protected static final char CLASS_SEPARATOR = ' ';
    protected static final char CSS_SEPARATOR = ';';
    protected String tag;
    protected String id;
    protected StringBuilder cssClass;
    protected StringBuilder cssStyle;

    public StringBuilder toHtml() {
        StringBuilder html = new StringBuilder();
        html.append((CharSequence)this.getHtmlOpeningTag());
        html.append((CharSequence)this.getHtmlClosingTag());
        return html;
    }

    protected StringBuilder getHtmlOpeningTag() {
        StringBuilder html = new StringBuilder();
        html.append('<');
        html.append(this.tag);
        html.append((CharSequence)this.getHtmlAttributes());
        html.append('>');
        return html;
    }

    protected StringBuilder getHtmlAttributes() {
        StringBuilder html = new StringBuilder();
        html.append((CharSequence)HtmlTag.writeAttribute("id", this.id));
        html.append((CharSequence)HtmlTag.writeAttribute("class", this.cssClass));
        html.append((CharSequence)HtmlTag.writeAttribute("style", this.cssStyle));
        return html;
    }

    protected static StringBuilder writeAttribute(String name, Object data) {
        StringBuilder html = new StringBuilder();
        if (data != null) {
            html.append(' ');
            html.append(name);
            html.append("=\"");
            html.append(data.toString());
            html.append('\"');
        }
        return html;
    }

    protected StringBuilder getHtmlClosingTag() {
        StringBuilder html = new StringBuilder();
        html.append("</");
        html.append(this.tag);
        html.append('>');
        return html;
    }

    public String getTag() {
        return this.tag;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public StringBuilder getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(StringBuilder cssClass) {
        this.cssClass = cssClass;
    }

    public StringBuilder getCssStyle() {
        return this.cssStyle;
    }

    public void setCssStyle(StringBuilder cssStyle) {
        this.cssStyle = cssStyle;
    }

    public void addCssClass(String cssClass) {
        if (this.cssClass == null) {
            this.cssClass = new StringBuilder();
        } else {
            this.cssClass.append(' ');
        }
        this.cssClass.append(cssClass);
    }

    public void addCssStyle(String cssStyle) {
        if (this.cssStyle == null) {
            this.cssStyle = new StringBuilder();
        } else {
            this.cssStyle.append(';');
        }
        this.cssStyle.append(cssStyle);
    }
}

