/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.plugin;

import com.github.dandelion.datatables.core.asset.JsResource;
import com.github.dandelion.datatables.core.asset.ResourceType;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.plugin.AbstractPlugin;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONValue;

public class FixedHeaderPlugin
extends AbstractPlugin {
    @Override
    public String getName() {
        return "FixedHeader";
    }

    @Override
    public String getVersion() {
        return "2.0.6";
    }

    @Override
    public void setup(HtmlTable table) {
        Map<String, Object> specificConfObj = this.getSpecificCongiguration(table);
        String specificConfStr = null;
        if (!specificConfObj.isEmpty()) {
            specificConfStr = JSONValue.toJSONString(specificConfObj);
            this.appendToBeforeEndDocumentReady("new FixedHeader(oTable_" + table.getId() + "," + specificConfStr + ");");
        } else {
            this.appendToBeforeEndDocumentReady("new FixedHeader(oTable_" + table.getId() + ");");
        }
        this.addJsResource(new JsResource(ResourceType.PLUGIN, "FixedHeader", "datatables/plugins/fixedheader/fixedheader.min.js"));
    }

    private Map<String, Object> getSpecificCongiguration(HtmlTable table) {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)table.getFixedPosition())) {
            if (table.getFixedPosition().equals("bottom")) {
                conf.put("bottom", true);
            } else if (table.getFixedPosition().equals("right")) {
                conf.put("right", true);
            } else if (table.getFixedPosition().equals("left")) {
                conf.put("left", true);
            } else {
                this.appendToBeforeEndDocumentReady("new FixedHeader(oTable_" + table.getId() + ");");
            }
        } else {
            conf.put("top", true);
        }
        if (table.getFixedOffsetTop() != null) {
            conf.put("offsetTop", table.getFixedOffsetTop());
        }
        return conf;
    }
}

