/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.properties;

import com.github.dandelion.datatables.core.exception.BadConfigurationException;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoader {
    private static Logger logger = LoggerFactory.getLogger(PropertiesLoader.class);
    public static final String DT_DEFAULT_PROPERTIES = "config/datatables-default.properties";
    public static final String DT_CUSTOM_PROPERTIES = "datatables.properties";
    private static Properties loadedProperties;

    public static void load(HtmlTable table) throws BadConfigurationException {
        if (loadedProperties == null) {
            PropertiesLoader.loadProperties();
        }
        table.getTableProperties().initProperties(loadedProperties);
    }

    private static synchronized void loadProperties() throws BadConfigurationException {
        if (loadedProperties != null) {
            return;
        }
        Properties propertiesResource = new Properties();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream propertiesStream = classLoader.getResourceAsStream(DT_DEFAULT_PROPERTIES);
        try {
            propertiesResource.load(propertiesStream);
        }
        catch (IOException e) {
            throw new BadConfigurationException("Unable to load the default configuration file", e);
        }
        propertiesStream = classLoader.getResourceAsStream(DT_CUSTOM_PROPERTIES);
        if (propertiesStream != null) {
            Properties customProperties = new Properties();
            try {
                customProperties.load(propertiesStream);
            }
            catch (IOException e) {
                throw new BadConfigurationException("Unable to load the project-specific configuration file", e);
            }
            propertiesResource.putAll((Map<?, ?>)customProperties);
        } else {
            logger.info("No custom file datatables.properties has been found. Using default one.");
        }
        loadedProperties = propertiesResource;
    }
}

