/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.properties;

import com.github.dandelion.datatables.core.aggregator.AggregatorMode;
import com.github.dandelion.datatables.core.compressor.CompressorMode;
import com.github.dandelion.datatables.core.export.ExportType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class TableProperties {
    private Properties propertiesResource;

    public void initProperties(Properties properties) {
        this.propertiesResource = properties;
    }

    public void setProperty(String key, String value) {
        this.propertiesResource.put(key, value);
    }

    public String getProperty(String key) {
        return this.propertiesResource.getProperty(key);
    }

    public Boolean isValidProperty(String property) {
        return property.equals("url.base") || property.equals("compressor.class") || property.equals("compressor.enable") || property.equals("compressor.mode") || property.equals("compressor.munge") || property.equals("compressor.preserveSemiColons") || property.equals("compressor.disableOptimizations") || property.equals("aggregator.enable") || property.equals("aggregator.mode") || property.equals("export.types") || property.equals("export.xls.default.class") || property.equals("export.xlsx.default.class") || property.equals("export.pdf.default.class") || property.equals("export.csv.class") || property.equals("export.xml.class") || property.equals("export.xls.class") || property.equals("export.xlsx.class") || property.equals("export.pdf.class");
    }

    public String getBaseUrl() {
        return this.getProperty("url.base");
    }

    public String getCompressorClassName() {
        return this.getProperty("compressor.class");
    }

    public Boolean isCompressorEnable() {
        return Boolean.parseBoolean(this.getProperty("compressor.enable"));
    }

    public CompressorMode getCompressorMode() {
        return CompressorMode.valueOf(this.getProperty("compressor.mode"));
    }

    public Boolean getCompressorMunge() {
        return Boolean.parseBoolean(this.getProperty("compressor.munge"));
    }

    public Boolean getCompressorPreserveSemi() {
        return Boolean.parseBoolean(this.getProperty("compressor.preserveSemiColons"));
    }

    public Boolean getCompressorDisableOpti() {
        return Boolean.parseBoolean(this.getProperty("compressor.disableOptimizations"));
    }

    public Boolean isAggregatorEnable() {
        return Boolean.parseBoolean(this.getProperty("aggregator.enable"));
    }

    public AggregatorMode getAggregatorMode() {
        return AggregatorMode.valueOf(this.getProperty("aggregator.mode"));
    }

    public List<ExportType> getExportTypes() {
        ArrayList<ExportType> exportTypes = new ArrayList<ExportType>();
        List<String> exportTypesString = Arrays.asList(this.getProperty("export.types").split(","));
        for (String type : exportTypesString) {
            exportTypes.add(ExportType.valueOf(type));
        }
        return exportTypes;
    }

    public String getExportClass(ExportType exportType) {
        String exportClass = null;
        switch (exportType) {
            case CSV: {
                exportClass = this.getProperty("export.csv.class");
                if (exportClass != null) break;
                exportClass = this.getProperty("export.csv.default.class");
                break;
            }
            case PDF: {
                exportClass = this.getProperty("export.pdf.class");
                if (exportClass != null) break;
                exportClass = this.getProperty("export.pdf.default.class");
                break;
            }
            case XLS: {
                exportClass = this.getProperty("export.xls.class");
                if (exportClass != null) break;
                exportClass = this.getProperty("export.xls.default.class");
                break;
            }
            case XLSX: {
                exportClass = this.getProperty("export.xlsx.class");
                if (exportClass != null) break;
                exportClass = this.getProperty("export.xlsx.default.class");
                break;
            }
            case XML: {
                exportClass = this.getProperty("export.xml.class");
                if (exportClass != null) break;
                exportClass = this.getProperty("export.xml.default.class");
                break;
            }
        }
        return exportClass;
    }
}

