/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.util;

import com.github.dandelion.datatables.core.exception.BadConfigurationException;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectHelper {
    private static Logger logger = LoggerFactory.getLogger(ReflectHelper.class);

    public static Class<?> getClass(String className) throws BadConfigurationException {
        Class klass = null;
        try {
            klass = ClassUtils.getClass((String)className);
        }
        catch (ClassNotFoundException e) {
            logger.error("Unable to get class {}", (Object)className);
            throw new BadConfigurationException(e);
        }
        return klass;
    }

    public static Object getNewInstance(Class<?> klass) throws BadConfigurationException {
        Object retval = null;
        try {
            retval = klass.newInstance();
        }
        catch (InstantiationException e) {
            logger.error("Unable to get instance of {}", klass);
            throw new BadConfigurationException(e);
        }
        catch (IllegalAccessException e) {
            logger.error("Unable to get instance of {}", klass);
            throw new BadConfigurationException(e);
        }
        return retval;
    }

    public static Object invokeMethod(Object obj, String methodName, Object[] args) throws BadConfigurationException {
        Object retval = null;
        try {
            retval = MethodUtils.invokeMethod((Object)obj, (String)methodName, (Object[])args);
        }
        catch (NoSuchMethodException e) {
            logger.error("Unable to invoke method {}", (Object)methodName);
            throw new BadConfigurationException(e);
        }
        catch (IllegalAccessException e) {
            logger.error("Unable to invoke method {}", (Object)methodName);
            throw new BadConfigurationException(e);
        }
        catch (InvocationTargetException e) {
            logger.error("Unable to invoke method {}", (Object)methodName);
            throw new BadConfigurationException(e);
        }
        return retval;
    }

    public static Boolean canBeUsed(String className) {
        Boolean canBeUsed = false;
        try {
            ClassUtils.getClass((String)className);
            canBeUsed = true;
        }
        catch (ClassNotFoundException e) {
            logger.warn("Unable to get class {}", (Object)className);
        }
        return canBeUsed;
    }
}

