/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.util;

import com.github.dandelion.datatables.core.exception.DataTableProcessingException;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class RequestHelper {
    public static String getCurrentUrl(HttpServletRequest request) {
        String currentUrl = null;
        currentUrl = request.getAttribute("javax.servlet.forward.request_uri") != null ? (String)request.getAttribute("javax.servlet.forward.request_uri") : request.getRequestURL().toString();
        if (currentUrl != null && request.getAttribute("javax.servlet.include.query_string") != null) {
            currentUrl = currentUrl + "?" + request.getQueryString();
        }
        return currentUrl;
    }

    public static String getCurrentUrlWithParameters(HttpServletRequest request) {
        String currentUrl = null;
        currentUrl = request.getAttribute("javax.servlet.forward.request_uri") != null ? (String)request.getAttribute("javax.servlet.forward.request_uri") : request.getRequestURL().toString();
        if (currentUrl != null && request.getQueryString() != null) {
            currentUrl = currentUrl + "?" + request.getQueryString();
        }
        return currentUrl;
    }

    public static String getAssetSource(String resourceName, HtmlTable table, HttpServletRequest request, boolean isMainFile) {
        StringBuilder buffer = new StringBuilder(RequestHelper.getBaseUrl((ServletRequest)request, table));
        buffer.append("/datatablesController/");
        buffer.append(resourceName);
        buffer.append("?id=");
        buffer.append(table.getId());
        if (isMainFile) {
            buffer.append("&t=main");
        }
        if (request.getQueryString() != null) {
            buffer.append("&");
            buffer.append(request.getQueryString());
        }
        buffer.append("&c=");
        try {
            buffer.append(URLEncoder.encode(RequestHelper.getCurrentUrlWithParameters(request), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new DataTableProcessingException();
        }
        return buffer.toString();
    }

    public static String getDatasourceUrl(String url, ServletRequest servletRequest, HtmlTable table) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (url.startsWith("/")) {
            return RequestHelper.getBaseUrl((ServletRequest)request, table) + url;
        }
        return url;
    }

    public static String getBaseUrl(ServletRequest servletRequest, HtmlTable table) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String baseUrl = null;
        if (StringUtils.isNotBlank((String)table.getTableProperties().getBaseUrl())) {
            String[] url = request.getRequestURL().toString().split("/");
            baseUrl = url[0] + "//" + table.getTableProperties().getBaseUrl();
        } else {
            baseUrl = request.getRequestURL().toString();
        }
        return baseUrl.replace(request.getRequestURI(), request.getContextPath());
    }

    public static String getBaseUrlWithParameters(ServletRequest servletRequest, HtmlTable table) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String retval = RequestHelper.getBaseUrl((ServletRequest)request, table);
        if (request.getQueryString() != null) {
            retval = retval + request.getQueryString();
        }
        return retval;
    }

    public static Boolean isTableBeingExported(ServletRequest servletRequest, HtmlTable table) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        return request.getAttribute("dti") != null ? request.getAttribute("dti").toString().toLowerCase().equals(table.getId().toLowerCase()) : false;
    }
}

