/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.util;

import com.github.dandelion.datatables.core.exception.BadConfigurationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.apache.commons.lang.RandomStringUtils;

public class ResourceHelper {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static InputStream getFileFromWebapp(String pathToFile) throws BadConfigurationException {
        File file = new File(pathToFile);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new BadConfigurationException(e);
        }
        return inputStream;
    }

    public static InputStream getFileFromClasspath(String pathToFile) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(pathToFile);
    }

    public static String getFileContentFromClasspath(String pathToFile) throws BadConfigurationException {
        String retval = null;
        try {
            retval = ResourceHelper.toString(ResourceHelper.getFileFromClasspath(pathToFile));
        }
        catch (IOException e) {
            throw new BadConfigurationException(e);
        }
        return retval;
    }

    public static String getFileContentFromWebapp(String pathToFile) throws BadConfigurationException {
        String retval = null;
        try {
            retval = ResourceHelper.toString(ResourceHelper.getFileFromWebapp(pathToFile));
        }
        catch (IOException e) {
            throw new BadConfigurationException(e);
        }
        return retval;
    }

    public static String toString(InputStream input) throws IOException {
        StringWriter sw = new StringWriter();
        InputStreamReader in = new InputStreamReader(input);
        char[] buffer = new char[4096];
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            sw.write(buffer, 0, n);
        }
        return sw.toString();
    }

    public static String getRamdomNumber() {
        return RandomStringUtils.randomNumeric((int)5);
    }
}

