/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.web.filter;

import com.github.dandelion.datatables.core.export.ExportProperties;
import com.github.dandelion.datatables.core.web.filter.DatatablesResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebFilter(filterName="DataTablesFilter", value={"/*"})
public class DatatablesFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            if (request.getParameter("dti") == null) {
                chain.doFilter(servletRequest, servletResponse);
            } else {
                request.setAttribute("dti", (Object)request.getParameter("dti"));
                HttpServletResponse response = (HttpServletResponse)servletResponse;
                DatatablesResponseWrapper resWrapper = new DatatablesResponseWrapper(response);
                chain.doFilter((ServletRequest)request, (ServletResponse)resWrapper);
                ExportProperties exportProperties = (ExportProperties)request.getAttribute("ddl-dt-export-properties");
                String fileName = exportProperties.getFileName() + "." + exportProperties.getCurrentExportType().getExtension();
                response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                response.setContentType(exportProperties.getCurrentExportType().getMimeType());
                if (exportProperties.isBinaryExport().booleanValue()) {
                    byte[] content = (byte[])servletRequest.getAttribute("ddl-dt-export-content");
                    response.setContentLength(content.length);
                    ServletOutputStream out = response.getOutputStream();
                    out.write(content);
                    out.flush();
                    out.close();
                } else {
                    String content = String.valueOf(servletRequest.getAttribute("ddl-dt-export-content"));
                    PrintWriter out = servletResponse.getWriter();
                    response.setContentLength(content.length());
                    out.write(content);
                    out.flush();
                    out.close();
                }
            }
        } else {
            chain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }
}

