/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.web.servlet;

import com.github.dandelion.datatables.core.asset.WebResources;
import com.github.dandelion.datatables.core.cache.AssetCache;
import com.github.dandelion.datatables.core.util.DandelionUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="datatablesController", urlPatterns={"/datatablesController/*"})
public class DatatablesServlet
extends HttpServlet {
    private static final long serialVersionUID = 4971523176859296399L;
    private static Logger logger = LoggerFactory.getLogger(DatatablesServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug("DataTables servlet captured GET request {}", (Object)request.getRequestURI());
        response.setHeader("Cache-Control", "no-cache");
        StringBuffer resourceUrl = request.getRequestURL();
        String resourceName = resourceUrl.substring(resourceUrl.lastIndexOf("/") + 1);
        String fileContent = null;
        String mainKey = request.getParameter("c") + "|" + request.getParameter("id");
        String type = request.getParameter("t");
        if (DandelionUtils.isDevModeEnabled() || AssetCache.cache.containsKey(mainKey)) {
            if (resourceName.endsWith("js")) {
                response.setContentType("application/javascript");
                fileContent = "main".equals(type) ? ((WebResources)AssetCache.cache.get(mainKey)).getMainJsFile().getContent() : ((WebResources)AssetCache.cache.get(mainKey)).getJavascripts().get(resourceName).getContent();
            } else if (resourceName.endsWith("css")) {
                response.setContentType("text/css");
                fileContent = ((WebResources)AssetCache.cache.get(mainKey)).getStylesheets().get(resourceName).getContent();
            }
        } else {
            throw new ServletException("The Dandelion assets should have been generated!");
        }
        response.getWriter().write(fileContent);
    }
}

