/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.extras.export.poi;

import com.github.dandelion.datatables.core.asset.DisplayType;
import com.github.dandelion.datatables.core.exception.ExportException;
import com.github.dandelion.datatables.core.export.AbstractBinaryExport;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.export.ExportType;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlRow;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;

public class XlsExport
extends AbstractBinaryExport {
    private HtmlTable table;
    private ExportConf exportConf;

    public void initExport(HtmlTable table) {
        this.table = table;
        if (table.getExportConfMap().containsKey(ExportType.XLS)) {
            this.exportConf = (ExportConf)table.getExportConfMap().get(ExportType.XLS);
        }
    }

    public void processExport(OutputStream output) throws ExportException {
        try {
            int cellnum;
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet("Sample sheet");
            HSSFRow row = null;
            Cell cell = null;
            int rownum = 0;
            if (this.exportConf.getIncludeHeader().booleanValue()) {
                for (HtmlRow htmlRow : this.table.getHeadRows()) {
                    row = sheet.createRow(rownum++);
                    cellnum = 0;
                    for (HtmlColumn column : htmlRow.getColumns()) {
                        if (!column.getEnabledDisplayTypes().contains(DisplayType.ALL) && !column.getEnabledDisplayTypes().contains(DisplayType.XLS)) continue;
                        cell = row.createCell(cellnum++);
                        cell.setCellValue(column.getContent().toString());
                        if (!this.exportConf.getAutoSize().booleanValue()) continue;
                        sheet.autoSizeColumn(cellnum);
                    }
                }
            }
            for (HtmlRow htmlRow : this.table.getBodyRows()) {
                row = sheet.createRow(rownum++);
                cellnum = 0;
                for (HtmlColumn column : htmlRow.getColumns()) {
                    if (!column.getEnabledDisplayTypes().contains(DisplayType.ALL) && !column.getEnabledDisplayTypes().contains(DisplayType.XLS)) continue;
                    cell = row.createCell(cellnum++);
                    cell.setCellValue(column.getContent().toString());
                    if (!this.exportConf.getAutoSize().booleanValue()) continue;
                    sheet.autoSizeColumn(cellnum);
                }
            }
            workbook.write(output);
        }
        catch (IOException e) {
            throw new ExportException((Throwable)e);
        }
    }
}

