/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor;

import com.github.dandelion.datatables.core.aggregator.ResourceAggregator;
import com.github.dandelion.datatables.core.asset.WebResources;
import com.github.dandelion.datatables.core.cache.AssetCache;
import com.github.dandelion.datatables.core.compressor.ResourceCompressor;
import com.github.dandelion.datatables.core.exception.BadConfigurationException;
import com.github.dandelion.datatables.core.exception.CompressionException;
import com.github.dandelion.datatables.core.exception.DataNotFoundException;
import com.github.dandelion.datatables.core.exception.ExportException;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.export.ExportDelegate;
import com.github.dandelion.datatables.core.export.ExportProperties;
import com.github.dandelion.datatables.core.export.ExportType;
import com.github.dandelion.datatables.core.feature.AbstractFeature;
import com.github.dandelion.datatables.core.feature.FilteringFeature;
import com.github.dandelion.datatables.core.generator.WebResourceGenerator;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.util.DandelionUtils;
import com.github.dandelion.datatables.core.util.RequestHelper;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesElProcessor;
import com.github.dandelion.datatables.thymeleaf.util.DomUtils;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.processor.IElementNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class TableFinalizerElProcessor
extends AbstractDatatablesElProcessor {
    private static Logger logger = LoggerFactory.getLogger(TableFinalizerElProcessor.class);
    private HtmlTable htmlTable;

    public TableFinalizerElProcessor(IElementNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 50000;
    }

    @Override
    protected ProcessorResult doProcessElement(Arguments arguments, Element element, HtmlTable table) {
        HttpServletRequest request = ((IWebContext)arguments.getContext()).getHttpServletRequest();
        this.htmlTable = table;
        if (this.htmlTable != null) {
            if (RequestHelper.isTableBeingExported((ServletRequest)request, (HtmlTable)this.htmlTable).booleanValue()) {
                this.setupExport(arguments);
            } else {
                this.setupHtmlGeneration(arguments, element, request);
            }
        }
        element.getParent().removeChild((Node)element);
        return ProcessorResult.OK;
    }

    private void registerFeatures(Element element, Arguments arguments, HtmlTable htmlTable) {
        if (htmlTable.hasOneFilterableColumn().booleanValue()) {
            logger.info("Feature detected : select with filter");
            this.generateFooter(element, arguments);
            htmlTable.registerFeature((AbstractFeature)new FilteringFeature());
        }
    }

    private void setupExport(Arguments arguments) {
        logger.debug("Setting export up ...");
        HttpServletRequest request = ((IWebContext)arguments.getContext()).getHttpServletRequest();
        HttpServletResponse response = ((IWebContext)arguments.getContext()).getHttpServletResponse();
        ExportProperties exportProperties = new ExportProperties();
        ExportType currentExportType = this.getCurrentExportType(request);
        exportProperties.setCurrentExportType(currentExportType);
        exportProperties.setExportConf((ExportConf)this.htmlTable.getExportConfMap().get(currentExportType));
        exportProperties.setFileName(((ExportConf)this.htmlTable.getExportConfMap().get(currentExportType)).getFileName());
        this.htmlTable.setExportProperties(exportProperties);
        this.htmlTable.setExporting(Boolean.valueOf(true));
        try {
            ExportDelegate exportDelegate = new ExportDelegate(this.htmlTable, exportProperties, request);
            exportDelegate.launchExport();
        }
        catch (ExportException e) {
            logger.error("Something went wront with the Dandelion-datatables export configuration.");
            e.printStackTrace();
        }
        response.reset();
    }

    private void setupHtmlGeneration(Arguments arguments, Element element, HttpServletRequest request) {
        WebResources webResources = null;
        this.htmlTable.setExporting(Boolean.valueOf(false));
        this.registerFeatures(element, arguments, this.htmlTable);
        try {
            String src;
            String keyToTest = RequestHelper.getCurrentUrlWithParameters((HttpServletRequest)request) + "|" + this.htmlTable.getId();
            if (DandelionUtils.isDevModeEnabled() || !AssetCache.cache.containsKey(keyToTest)) {
                logger.debug("No asset for the key {}. Generating...", (Object)keyToTest);
                WebResourceGenerator contentGenerator = new WebResourceGenerator();
                webResources = contentGenerator.generateWebResources(this.htmlTable);
                logger.debug("Web content generated successfully");
                AssetCache.cache.put(keyToTest, webResources);
                logger.debug("Cache updated with new web resources");
            } else {
                logger.debug("Asset(s) already exist, retrieving content from cache...");
                webResources = (WebResources)AssetCache.cache.get(keyToTest);
            }
            if (this.htmlTable.getTableProperties().isAggregatorEnable().booleanValue()) {
                logger.debug("Aggregation enabled");
                ResourceAggregator.processAggregation((WebResources)webResources, (HtmlTable)this.htmlTable);
            }
            if (this.htmlTable.getTableProperties().isCompressorEnable().booleanValue()) {
                logger.debug("Compression enabled");
                ResourceCompressor.processCompression((WebResources)webResources, (HtmlTable)this.htmlTable);
            }
            if (this.htmlTable.getCdn() != null && this.htmlTable.getCdn().booleanValue()) {
                DomUtils.addLinkTag(DomUtils.getParentAsElement(element), request, "//ajax.aspnetcdn.com/ajax/jquery.dataTables/1.9.4/css/jquery.dataTables.css");
            }
            for (Map.Entry entry : webResources.getStylesheets().entrySet()) {
                src = RequestHelper.getAssetSource((String)((String)entry.getKey()), (HtmlTable)this.htmlTable, (HttpServletRequest)request, (boolean)false);
                DomUtils.addLinkTag(element, request, src);
            }
            if (this.htmlTable.getCdn() != null && this.htmlTable.getCdn().booleanValue()) {
                DomUtils.addScriptTag(DomUtils.getParentAsElement(element), request, "//ajax.aspnetcdn.com/ajax/jquery.dataTables/1.9.4/jquery.dataTables.min.js");
            }
            for (Map.Entry entry : webResources.getJavascripts().entrySet()) {
                src = RequestHelper.getAssetSource((String)((String)entry.getKey()), (HtmlTable)this.htmlTable, (HttpServletRequest)request, (boolean)false);
                DomUtils.addScriptTag(DomUtils.getParentAsElement(element), request, src);
            }
            String src2 = RequestHelper.getAssetSource((String)webResources.getMainJsFile().getName(), (HtmlTable)this.htmlTable, (HttpServletRequest)request, (boolean)true);
            DomUtils.addScriptTag(DomUtils.getParentAsElement(element), request, src2);
            logger.debug("Web content generated successfully");
        }
        catch (CompressionException e) {
            logger.error("Something went wront with the compressor.");
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (BadConfigurationException e) {
            logger.error("Something went wront with the Dandelion-datatables configuration.");
            throw new RuntimeException(e);
        }
        catch (DataNotFoundException e) {
            logger.error("Something went wront with the data provider.");
            throw new RuntimeException(e);
        }
    }

    private ExportType getCurrentExportType(HttpServletRequest request) {
        String exportTypeString = request.getParameter("dtt");
        return ExportType.findByUrlParameter((Integer)Integer.parseInt(exportTypeString));
    }

    private void generateFooter(Element element, Arguments arguments) {
        Element tfoot = new Element("tfoot");
        Node tableNode = (Node)((IWebContext)arguments.getContext()).getHttpServletRequest().getAttribute("tableNode");
        for (HtmlColumn column : this.htmlTable.getLastHeaderRow().getColumns()) {
            Element th = new Element("th");
            th.addChild((Node)new Text(column.getContent()));
            tfoot.addChild((Node)th);
        }
        ((Element)tableNode).addChild((Node)tfoot);
    }
}

