/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor;

import com.github.dandelion.datatables.core.exception.BadConfigurationException;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.properties.PropertiesLoader;
import com.github.dandelion.datatables.core.util.RequestHelper;
import com.github.dandelion.datatables.core.util.ResourceHelper;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesElProcessor;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.IElementNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class TableInitializerElProcessor
extends AbstractDatatablesElProcessor {
    private static Logger logger = LoggerFactory.getLogger(TableInitializerElProcessor.class);

    public TableInitializerElProcessor(IElementNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 3500;
    }

    @Override
    protected ProcessorResult doProcessElement(Arguments arguments, Element element, HtmlTable table) {
        String tableId = element.getAttributeValue("id");
        logger.debug("{} element found with id {}", (Object)element.getNormalizedName(), (Object)tableId);
        HttpServletRequest request = ((IWebContext)arguments.getContext()).getHttpServletRequest();
        if (tableId == null) {
            logger.error("The 'id' attribute is required.");
            throw new IllegalArgumentException();
        }
        HtmlTable htmlTable = new HtmlTable(tableId, ResourceHelper.getRamdomNumber());
        htmlTable.setCurrentUrl(RequestHelper.getCurrentUrl((HttpServletRequest)request));
        try {
            PropertiesLoader.load((HtmlTable)htmlTable);
        }
        catch (BadConfigurationException e) {
            logger.error("Unable to load Dandelion-datatables configuration");
            e.printStackTrace();
        }
        htmlTable.addHeaderRow();
        htmlTable.addFooterRow();
        Element div = new Element("div");
        div.setAttribute("dt:tmp", "internalUse");
        div.setRecomputeProcessorsImmediately(true);
        element.getParent().insertAfter((Node)element, (Node)div);
        ((IWebContext)arguments.getContext()).getHttpServletRequest().setAttribute("htmlTable", (Object)htmlTable);
        ((IWebContext)arguments.getContext()).getHttpServletRequest().setAttribute("tableNode", (Object)element);
        element.removeAttribute("dt:table");
        return ProcessorResult.OK;
    }
}

