/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor;

import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesElProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.IElementNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class TbodyElProcessor
extends AbstractDatatablesElProcessor {
    private static Logger logger = LoggerFactory.getLogger(TbodyElProcessor.class);

    public TbodyElProcessor(IElementNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 4000;
    }

    @Override
    protected ProcessorResult doProcessElement(Arguments arguments, Element element, HtmlTable table) {
        logger.debug("{} element found", (Object)element.getNormalizedName());
        for (Node child : element.getChildren()) {
            if (child == null || !(child instanceof Element)) continue;
            Element trChildTag = (Element)child;
            String trChildTagName = trChildTag.getNormalizedName();
            trChildTag.setProcessable(true);
            if (trChildTagName == null || !trChildTagName.equals("tr") || !trChildTag.hasAttribute("th:each")) continue;
            trChildTag.setAttribute("dt:data", "internalUse");
            for (Node grandchild : trChildTag.getChildren()) {
                if (grandchild == null || !(grandchild instanceof Element)) continue;
                Element tdChildTag = (Element)grandchild;
                tdChildTag.setAttribute("dt:data", "internalUse");
                tdChildTag.setProcessable(true);
            }
        }
        return ProcessorResult.ok();
    }
}

