/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.thymeleaf.processor.ajax;

import com.github.dandelion.datatables.core.feature.AbstractFeature;
import com.github.dandelion.datatables.core.feature.ServerSideFeature;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.thymeleaf.dialect.AbstractDatatablesAttrProcessor;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;

public class TableServerSideAttrProcessor
extends AbstractDatatablesAttrProcessor {
    public TableServerSideAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public int getPrecedence() {
        return 7999;
    }

    @Override
    protected ProcessorResult doProcessAttribute(Arguments arguments, Element element, String attributeName, HtmlTable table) {
        Boolean attrValue = Boolean.parseBoolean(element.getAttributeValue(attributeName));
        if (table != null) {
            table.setServerSide(attrValue);
            if (attrValue.booleanValue()) {
                table.registerFeature((AbstractFeature)new ServerSideFeature());
            }
        }
        return ProcessorResult.ok();
    }
}

